/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import lombok.Generated;
import org.nuiton.util.pagination.PaginationResult;

public class EffectiveCropCyclesList
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 6687115109245346054L;
    protected EffectiveZoneFilter plotFilter;
    protected String filter;
    protected transient EffectiveCropCycleService effectiveCropCycleService;
    protected PaginationResult<ZoneDto> zoneListResult;
    protected boolean measurement;
    protected boolean importFileError;
    protected int exportAsyncThreshold;
    protected int measurementExportAsyncThreshold;

    public String execute() throws Exception {
        if (this.importFileError) {
            this.notificationSupport.importError("Format de fichier incorrect !");
            this.importFileError = false;
        }
        if (this.plotFilter == null) {
            this.plotFilter = new EffectiveZoneFilter();
            NavigationContext navigationContext = this.getNavigationContext();
            this.plotFilter.setNavigationContext(navigationContext);
            this.plotFilter.setZoneState(Boolean.valueOf(true));
            this.plotFilter.setPlotState(Boolean.valueOf(true));
        }
        this.plotFilter.setPageSize(this.getListNbElementByPage(ZoneDto.class, String.valueOf(this.measurement)).intValue());
        this.zoneListResult = this.effectiveCropCycleService.getFilteredZonesAndCroppingPlanInfosDto(this.plotFilter);
        this.exportAsyncThreshold = this.config.getEffectiveCropCyclesExportAsyncThreshold();
        this.measurementExportAsyncThreshold = this.config.getEffectiveMeasurementsExportAsyncThreshold();
        return "success";
    }

    public void setFilter(String filter) {
        this.plotFilter = (EffectiveZoneFilter)this.getGson().fromJson(filter, EffectiveZoneFilter.class);
    }

    @Generated
    public EffectiveZoneFilter getPlotFilter() {
        return this.plotFilter;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return this.effectiveCropCycleService;
    }

    @Generated
    public PaginationResult<ZoneDto> getZoneListResult() {
        return this.zoneListResult;
    }

    @Generated
    public boolean isMeasurement() {
        return this.measurement;
    }

    @Generated
    public boolean isImportFileError() {
        return this.importFileError;
    }

    @Generated
    public int getExportAsyncThreshold() {
        return this.exportAsyncThreshold;
    }

    @Generated
    public int getMeasurementExportAsyncThreshold() {
        return this.measurementExportAsyncThreshold;
    }

    @Generated
    public void setPlotFilter(EffectiveZoneFilter plotFilter) {
        this.plotFilter = plotFilter;
    }

    @Generated
    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    @Generated
    public void setZoneListResult(PaginationResult<ZoneDto> zoneListResult) {
        this.zoneListResult = zoneListResult;
    }

    @Generated
    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    @Generated
    public void setImportFileError(boolean importFileError) {
        this.importFileError = importFileError;
    }

    @Generated
    public void setExportAsyncThreshold(int exportAsyncThreshold) {
        this.exportAsyncThreshold = exportAsyncThreshold;
    }

    @Generated
    public void setMeasurementExportAsyncThreshold(int measurementExportAsyncThreshold) {
        this.measurementExportAsyncThreshold = measurementExportAsyncThreshold;
    }
}

