/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AbstractDomainInputStockUnit;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.PriceUnit;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.referential.CriteriaUnit;
import fr.inra.agrosyst.api.entities.referential.PastureType;
import fr.inra.agrosyst.api.entities.referential.RefDestination;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.WineValorisation;
import fr.inra.agrosyst.api.services.action.AbstractActionDto;
import fr.inra.agrosyst.api.services.action.HarvestingActionDto;
import fr.inra.agrosyst.api.services.action.HarvestingActionValorisationDto;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.domain.CattleDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputStockUnitService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleModelDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycles;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.services.common.AgrosystI18nService;
import fr.inra.agrosyst.web.actions.itk.AbstractItkAction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class EffectiveCropCyclesEdit
extends AbstractItkAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(EffectiveCropCyclesEdit.class);
    private static final long serialVersionUID = 3202026195271703990L;
    protected transient EffectiveCropCycleService effectiveCropCycleService;
    protected transient PlotService plotService;
    protected transient DomainService domainService;
    protected transient DomainInputStockUnitService domainInputStockUnitService;
    protected transient PricesService pricesService;
    protected String zoneTopiaId;
    protected Zone zone;
    protected Sector growingSystemSector = null;
    protected Boolean organic = null;
    protected List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles;
    protected String effectiveSeasonalCropCyclesJson;
    protected List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles;
    protected String effectivePerennialCropCyclesJson;
    protected List<CroppingPlanEntry> croppingPlanEntries;
    protected String croppingPlanEntriesJson;
    protected List<EffectiveCropCycleModelDto> effectiveCropCyclesMainModels;
    protected List<EffectiveCropCycleModelDto> effectiveCropCyclesIntermediateModels;
    protected List<RefOrientationEDI> refOrientationEDIs;
    protected String domainId;
    protected int campaign;
    protected LinkedHashMap<Integer, String> relatedZones;
    private Map<String, List<Pair<String, String>>> allCodeEspeceBotaniqueCodeQualifantBySpeciesCode;
    private Map<String, List<Sector>> allsectorByCodeEspceBotaniqueCodeQualifiant;
    protected Collection<CattleDto> cattles;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainInputStockUnitService(DomainInputStockUnitService domainInputStockUnitService) {
        this.domainInputStockUnitService = domainInputStockUnitService;
    }

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void prepare() {
        this.zone = this.effectiveCropCycleService.getZone(this.zoneTopiaId);
        this.domainId = this.zone.getPlot().getDomain().getTopiaId();
        this.campaign = this.zone.getPlot().getDomain().getCampaign();
        this.activated = this.zone.isActive() && this.zone.getPlot().isActive() && this.zone.getPlot().getDomain().isActive() && (this.zone.getPlot().getGrowingSystem() == null || this.zone.getPlot().getGrowingSystem().isActive());
    }

    @Action(value="effective-crop-cycles-edit-input")
    public String input() throws Exception {
        this.authorizationService.checkEffectiveCropCyclesReadable(this.zoneTopiaId);
        boolean bl = this.readOnly = !this.authorizationService.isZoneWritable(this.zoneTopiaId) || this.domainId == null;
        if (this.readOnly) {
            this.notificationSupport.effectiveCropCyclesNotWritable();
        }
        this.effectivePerennialCropCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(this.zoneTopiaId);
        this.effectivePerennialCropCyclesJson = this.getGson().toJson((Object)CollectionUtils.emptyIfNull((Collection)this.effectivePerennialCropCycles));
        this.effectiveSeasonalCropCycles = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(this.zoneTopiaId);
        this.effectiveSeasonalCropCycles = this.addNodeBefore(this.zoneTopiaId, this.effectiveSeasonalCropCycles);
        this.effectiveSeasonalCropCyclesJson = this.getGson().toJson((Object)this.effectiveSeasonalCropCycles);
        this.warnEdaplosDestinationUsage();
        this.initForInput();
        return "input";
    }

    private void warnEdaplosDestinationUsage() {
        ArrayList cropLabels = new ArrayList();
        HashMap<Integer, Set> cropNameByRank = new HashMap<Integer, Set>();
        List nodes = this.effectiveSeasonalCropCycles.stream().map(EffectiveSeasonalCropCycleDto::getNodeDtos).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        for (EffectiveCropCycleNodeDto node : nodes) {
            if (node.getInterventions() == null) continue;
            List<AbstractActionDto> harvestingActions = node.getInterventions().stream().filter(Objects::nonNull).map(EffectiveInterventionDto::getActionDtos).filter(Objects::nonNull).flatMap(Collection::stream).filter(action -> action instanceof HarvestingActionDto).toList();
            for (AbstractActionDto harvestingActionDto : harvestingActions) {
                Optional effectiveInterventionId;
                Set destinationIds = CollectionUtils.emptyIfNull((Collection)((HarvestingActionDto)harvestingActionDto).getValorisationDtos()).stream().filter(Objects::nonNull).map(HarvestingActionValorisationDto::getDestinationId).collect(Collectors.toSet());
                Optional<String> defaultDestination = this.referentialService.loadDestinationsForIds(destinationIds).stream().map(RefDestination::getDestination).filter("A compl\u00e9ter"::equals).findAny();
                if (!defaultDestination.isPresent() || !(effectiveInterventionId = harvestingActionDto.getEffectiveInterventionId()).isPresent()) continue;
                EffectiveIntervention intervention = this.effectiveCropCycleService.getEffectiveInterventionWithGivenId((String)effectiveInterventionId.get());
                Object cropLabel = intervention.isIntermediateCrop() ? node.getIntermediateCropLabel() + " (CI Rang %d) " : node.getLabel() + " (Rang %d) ";
                int rank = node.getX() + 1;
                cropLabel = String.format((String)cropLabel, rank);
                Set cropNamesForRank = cropNameByRank.computeIfAbsent(rank, k -> new HashSet());
                cropNamesForRank.add(cropLabel);
            }
        }
        if (!cropNameByRank.isEmpty()) {
            List odoredRank = cropNameByRank.keySet().stream().sorted(Integer::compareTo).toList();
            for (Integer rank : odoredRank) {
                ArrayList cropNames = new ArrayList((Collection)cropNameByRank.get(rank));
                cropNames.sort(String::compareTo);
                cropLabels.addAll(cropNames);
            }
        }
        ArrayList<String> perennialCropNames = new ArrayList<String>();
        for (EffectivePerennialCropCycleDto perennialCropCycle : this.effectivePerennialCropCycles) {
            if (CollectionUtils.isEmpty((Collection)perennialCropCycle.getPhaseDtos())) continue;
            Optional defaultDestination = EffectiveCropCyclesEdit.getDefaultDestination((EffectivePerennialCropCycleDto)perennialCropCycle);
            if (defaultDestination.isPresent()) {
                perennialCropNames.add(perennialCropCycle.getCroppingPlanEntryName());
            }
            if (!(defaultDestination = EffectiveCropCyclesEdit.getDefaultDestination((EffectivePerennialCropCycleDto)perennialCropCycle)).isPresent()) continue;
            perennialCropNames.add(perennialCropCycle.getCroppingPlanEntryName());
        }
        if (!perennialCropNames.isEmpty()) {
            perennialCropNames.sort(String::compareTo);
            cropLabels.addAll(perennialCropNames);
        }
        if (!cropLabels.isEmpty()) {
            this.notificationSupport.warning(String.format("Vous avez une destination de r\u00e9colte import\u00e9e par d\u00e9faut depuis eDaplos, pour la culture %s. Merci de corriger cette destination ainsi que le rendement correspondant (valeur et unit\u00e9).", String.join((CharSequence)", ", cropLabels)), new Object[0]);
        }
    }

    private static Optional<String> getDefaultDestination(EffectivePerennialCropCycleDto perennialCropCycle) {
        Optional<String> defaultDestination = perennialCropCycle.getPhaseDtos().stream().filter(Objects::nonNull).map(EffectiveCropCyclePhaseDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).map(EffectiveInterventionDto::getActionDtos).filter(Objects::nonNull).flatMap(Collection::stream).filter(actionDto -> actionDto instanceof HarvestingActionDto).filter(Objects::nonNull).map(actionDto -> ((HarvestingActionDto)actionDto).getValorisationDtos()).flatMap(Collection::stream).filter(Objects::nonNull).map(HarvestingActionValorisationDto::getDestinationName).filter("A compl\u00e9ter"::equals).findAny();
        return defaultDestination;
    }

    protected List<EffectiveSeasonalCropCycleDto> addNodeBefore(String zoneTopiaId, List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles) {
        CroppingPlanEntry beforeNodeCroppingPlanEntry = this.effectiveCropCycleService.getPreviousCampaignCroppingPlanEntry(zoneTopiaId);
        EffectiveCropCycleNodeDto previousNodeCroppingPlanEntry = new EffectiveCropCycleNodeDto();
        String beforeNodeLabel = beforeNodeCroppingPlanEntry != null ? beforeNodeCroppingPlanEntry.getName() : "";
        previousNodeCroppingPlanEntry.setLabel(beforeNodeLabel);
        previousNodeCroppingPlanEntry.setNodeId("NODE_BEFORE");
        previousNodeCroppingPlanEntry.setType("NODE_BEFORE");
        if (CollectionUtils.isEmpty(effectiveSeasonalCropCycles)) {
            EffectiveSeasonalCropCycleDto cropCycle = new EffectiveSeasonalCropCycleDto();
            cropCycle.setNodeDtos(new ArrayList());
            cropCycle.getNodeDtos().add(previousNodeCroppingPlanEntry);
            cropCycle.setConnectionDtos(new ArrayList());
            effectiveSeasonalCropCycles = Lists.newArrayList((Object[])new EffectiveSeasonalCropCycleDto[]{cropCycle});
        } else {
            for (EffectiveSeasonalCropCycleDto nodedto : effectiveSeasonalCropCycles) {
                nodedto.getNodeDtos().add(0, previousNodeCroppingPlanEntry);
                for (EffectiveCropCycleConnectionDto conndto : CollectionUtils.emptyIfNull((Collection)nodedto.getConnectionDtos())) {
                    if (conndto.getSourceId() != null) continue;
                    conndto.setSourceId(previousNodeCroppingPlanEntry.getNodeId());
                }
            }
        }
        return effectiveSeasonalCropCycles;
    }

    protected void initForInput() {
        GrowingSystem growingSystem;
        if (this.croppingPlanEntries == null) {
            this.croppingPlanEntries = this.domainId != null ? this.effectiveCropCycleService.getZoneCroppingPlanEntriesWithoutDomain(this.zone) : new ArrayList();
            this.croppingPlanEntriesJson = this.getGson().toJson((Object)this.croppingPlanEntries);
        }
        if ((growingSystem = this.zone.getPlot().getGrowingSystem()) != null) {
            this.growingSystemSector = growingSystem.getSector();
            this.organic = growingSystem.getTypeAgriculture() == null ? null : Boolean.valueOf(growingSystem.getTypeAgriculture().getReference_id() == 19948);
        }
        this.effectiveCropCyclesMainModels = new ArrayList();
        this.effectiveCropCyclesIntermediateModels = new ArrayList();
        for (CroppingPlanEntry croppingPlanEntry : this.croppingPlanEntries) {
            EffectiveCropCycleModelDto effectiveCropCycleModelDto = (EffectiveCropCycleModelDto)EffectiveCropCycles.CROPPING_PLAN_ENTRY_TO_DTO.apply(croppingPlanEntry);
            if (effectiveCropCycleModelDto.isIntermediate()) {
                this.effectiveCropCyclesIntermediateModels.add(effectiveCropCycleModelDto);
                continue;
            }
            this.effectiveCropCyclesMainModels.add(effectiveCropCycleModelDto);
        }
        this.refOrientationEDIs = this.referentialService.getAllReferentielEDI();
        this.relatedZones = this.plotService.getRelatedZones(this.zone.getCode());
        this.cattles = this.effectiveCropCycleService.getCattleForDomain(this.domainId);
        super.initForInput();
    }

    public void validate() {
        if (this.zone == null) {
            this.addFieldError("zoneTopiaId", "Zone can't be null");
        }
        if (this.zone != null && !this.activated) {
            this.addActionError("La zone et/ou sa parcelle et/ou son system de culture et/ou son dispositif et/ou son domain sont inactifs !");
        }
        try {
            this.effectiveSeasonalCropCycles = this.convertEffectiveSeasonalCropCyclesJson(this.effectiveSeasonalCropCyclesJson);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.toString());
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant vos cycles de cultures saisonniers n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
        }
        try {
            this.effectivePerennialCropCycles = this.convertEffectivePerennialCropCyclesJson(this.effectivePerennialCropCyclesJson);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.toString());
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant vos cycles de cultures p\u00e9rennes n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
        }
        if (this.zone != null) {
            this.allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = this.effectiveCropCycleService.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCodeForDomainIds(this.zone);
            this.allsectorByCodeEspceBotaniqueCodeQualifiant = this.effectiveCropCycleService.getSectorByCodeEspceBotaniqueCodeQualifiant(this.zone);
        }
        HashMap domainInputStockUnitByIds = this.zone != null ? this.domainInputStockUnitService.loadDomainInputStockByIds(this.zone.getPlot().getDomain()) : new HashMap();
        this.effectiveSeasonalCropCycles = this.validateSeasonalCropCycles(this.effectiveSeasonalCropCycles, this.zoneTopiaId, this.allCodeEspeceBotaniqueCodeQualifantBySpeciesCode, this.allsectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        this.effectivePerennialCropCycles = this.validatePerennialCropCycles(this.effectivePerennialCropCycles, this.zoneTopiaId, this.allCodeEspeceBotaniqueCodeQualifantBySpeciesCode, this.allsectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        this.validToolCouplingsOnInterventions();
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String zoneId = this.getLogEntityId((TopiaEntity)this.zone);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : cycle du r\u00e9alis\u00e9 pour zone:'%s' -> %s", zoneId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : cycle du r\u00e9alis\u00e9 pour zone:'%s' -> %s", zoneId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    private void validToolCouplingsOnInterventions() {
        List pInterventions;
        List sInterventions = this.effectiveSeasonalCropCycles.stream().map(EffectiveSeasonalCropCycleDto::getNodeDtos).filter(Objects::nonNull).flatMap(Collection::stream).map(EffectiveCropCycleNodeDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        if (CollectionUtils.union(sInterventions, pInterventions = this.effectivePerennialCropCycles.stream().map(EffectivePerennialCropCycleDto::getPhaseDtos).filter(Objects::nonNull).flatMap(Collection::stream).map(EffectiveCropCyclePhaseDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).toList()).stream().anyMatch(intervention -> intervention.getToolsCouplingCodes().isEmpty())) {
            this.notificationSupport.warning("Aucune combinaison d'outils ou intervention manuelle n'ont \u00e9t\u00e9 s\u00e9lectionn\u00e9es pour l'une de vos interventions. Ce champs est requis pour le calcul du temps de travail et de consommation de carburant.", new Object[0]);
        }
    }

    protected List<EffectivePerennialCropCycleDto> validatePerennialCropCycles(List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles, String zoneTopiaId, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        if (effectivePerennialCropCycles == null) {
            effectivePerennialCropCycles = this.effectiveCropCycleService.getAllEffectivePerennialCropCyclesDtos(zoneTopiaId);
        } else {
            for (EffectivePerennialCropCycleDto perennial : effectivePerennialCropCycles) {
                List allSpecies;
                Double plantingDensity;
                if (Strings.isNullOrEmpty((String)perennial.getCroppingPlanEntryId())) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir une culture de s\u00e9lectionn\u00e9e");
                }
                if (perennial.getWeedType() == null) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir un type d'enherbement de s\u00e9lectionn\u00e9e");
                }
                if (perennial.getPhaseDtos().size() != 1) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir une phase de d\u00e9clar\u00e9e");
                }
                if ((plantingDensity = perennial.getPlantingDensity()) != null && plantingDensity < 0.0) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir une densit\u00e9 de plantation positive");
                }
                if ((allSpecies = perennial.getSpeciesDtos()) != null && !allSpecies.isEmpty()) {
                    for (EffectiveCropCycleSpeciesDto speciesDto : allSpecies) {
                        if (!Strings.isNullOrEmpty((String)speciesDto.getCroppingPlanSpeciesId())) continue;
                        this.addActionError("Une esp\u00e8ce d'un cycle de culture p\u00e9renne ne peut-\u00eatre retrouv\u00e9e");
                    }
                }
                for (EffectiveCropCyclePhaseDto phase : perennial.getPhaseDtos()) {
                    if (phase.getType() == null) {
                        this.addActionError("Une phase d'un cycle de culture p\u00e9renne doit \u00eatre typ\u00e9e");
                    }
                    this.validatePerennialInterventions(phase, perennial.getCroppingPlanEntryName(), phase.getType(), speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
                }
            }
        }
        return effectivePerennialCropCycles;
    }

    protected List<EffectiveSeasonalCropCycleDto> validateSeasonalCropCycles(List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles, String zoneTopiaId, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        if (effectiveSeasonalCropCycles == null) {
            effectiveSeasonalCropCycles = this.effectiveCropCycleService.getAllEffectiveSeasonalCropCyclesDtos(zoneTopiaId);
        } else {
            EffectiveSeasonalCropCycleDto effectiveSeasonalCropCycleDto;
            boolean error;
            HashSet xAlreadyDefined = Sets.newHashSet();
            Iterator<EffectiveSeasonalCropCycleDto> iterator = effectiveSeasonalCropCycles.iterator();
            while (iterator.hasNext() && !(error = this.validateNodes((Set)xAlreadyDefined, effectiveSeasonalCropCycleDto = iterator.next(), speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds))) {
                this.validateConnections(effectiveSeasonalCropCycleDto);
            }
        }
        return effectiveSeasonalCropCycles;
    }

    private boolean validateNodes(Set<Integer> xAlreadyDefined, EffectiveSeasonalCropCycleDto effectiveSeasonalCropCycleDto, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        boolean error = false;
        List nodeDtos = effectiveSeasonalCropCycleDto.getNodeDtos();
        for (EffectiveCropCycleNodeDto nodeDto : nodeDtos) {
            if ("NODE_BEFORE".equals(nodeDto.getNodeId())) continue;
            if (xAlreadyDefined.contains(nodeDto.getX())) {
                this.addActionError("Une succession de cultures assol\u00e9es en r\u00e9alis\u00e9 doit \u00eatre lin\u00e9aire (une seule culture par rang).");
                error = true;
                break;
            }
            xAlreadyDefined.add(nodeDto.getX());
            this.validateSeasonalInterventions(nodeDto.getInterventions(), nodeDto.getLabel(), nodeDto.getX(), speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        }
        return error;
    }

    private void validateConnections(EffectiveSeasonalCropCycleDto effectiveSeasonalCropCycleDto) {
        Collection effectiveCropCycleConnectionDtos = CollectionUtils.emptyIfNull((Collection)effectiveSeasonalCropCycleDto.getConnectionDtos());
        HashSet sources = Sets.newHashSet();
        HashSet targets = Sets.newHashSet();
        for (EffectiveCropCycleConnectionDto connection : effectiveCropCycleConnectionDtos) {
            String targetId;
            String sourceId = connection.getSourceId();
            if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                if (sources.contains(sourceId)) {
                    this.addActionError("Une culture assol\u00e9e du r\u00e9alis\u00e9 ne peut avoir qu'une seule culture pr\u00e9c\u00e9dente");
                    break;
                }
                sources.add(sourceId);
            }
            if (!StringUtils.isNotBlank((CharSequence)(targetId = connection.getTargetId()))) continue;
            if (targets.contains(targetId)) {
                this.addActionError("Une culture assol\u00e9e du r\u00e9alis\u00e9 ne peut avoir qu'une seule culture suivante");
                break;
            }
            targets.add(targetId);
        }
    }

    protected void validateSeasonalInterventions(List<EffectiveInterventionDto> interventionDtos, String cropLabel, int cropRank, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        String interventionGeneralInfos = String.format("sur la culture assol\u00e9e '%s' (Rang %d)", cropLabel, cropRank + 1);
        this.validateInterventions(interventionDtos, interventionGeneralInfos, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
    }

    protected void validatePerennialInterventions(EffectiveCropCyclePhaseDto phase, String cropLabel, CropCyclePhaseType phaseType, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List interventionDtos = phase.getInterventions();
        String interventionGeneralInfos = String.format("sur la culture p\u00e9renne '%s' (%s)", cropLabel, AgrosystI18nService.getEnumTraductionWithDefaultLocale((Object)phaseType));
        this.validateInterventions(interventionDtos, interventionGeneralInfos, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
    }

    protected void validateInterventions(List<EffectiveInterventionDto> interventionDtos, String interventionContextInfo, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspeceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        if (CollectionUtils.isNotEmpty(interventionDtos)) {
            for (EffectiveInterventionDto interventionDto : interventionDtos) {
                Collection actionDtos;
                List actionDtoValidationResult;
                Double involvedPeopleCount;
                Double workRate;
                ArrayList<String> interventionErrorMessages = new ArrayList<String>();
                if (interventionDto.getType() == null) {
                    interventionErrorMessages.add("- Renseigner le type de l'intervention");
                }
                if (Strings.isNullOrEmpty((String)interventionDto.getName())) {
                    interventionErrorMessages.add("- Renseigner le nom de l'intervention");
                }
                if (interventionDto.getStartInterventionDate() == null) {
                    interventionErrorMessages.add("- Renseigner la date de d\u00e9but de l'intervention");
                }
                if (interventionDto.getEndInterventionDate() == null) {
                    interventionErrorMessages.add("- Renseigner la date de fin de l'intervention");
                }
                if ((workRate = interventionDto.getWorkRate()) != null && workRate < 0.0) {
                    interventionErrorMessages.add("- Le d\u00e9bit de chantier doit \u00eatre positif");
                }
                if ((involvedPeopleCount = interventionDto.getInvolvedPeopleCount()) != null && involvedPeopleCount < 0.0) {
                    interventionErrorMessages.add("- Le nombre de personnes mobilis\u00e9es doit \u00eatre positif");
                }
                if (CollectionUtils.isNotEmpty((Collection)(actionDtoValidationResult = this.actionService.validActionDtosAndUsages(actionDtos = interventionDto.getActionDtos(), domainInputStockUnitByIds, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspeceBotaniqueCodeQualifiant, interventionDto.getSpeciesStadesDtos(), interventionDto.isIntermediateCrop())))) {
                    String interventionName = StringUtils.isBlank((CharSequence)interventionDto.getName()) ? "?" : interventionDto.getName();
                    String interventionGeneralInfos = String.format("Intervention '%s' %s&nbsp:<br>", interventionName, interventionContextInfo);
                    String messages = StringUtils.join(interventionErrorMessages, (String)"<br>");
                    this.addActionError(interventionGeneralInfos + messages);
                    continue;
                }
                if (interventionErrorMessages.isEmpty()) continue;
                String messages = StringUtils.join(interventionErrorMessages, (String)"<br>");
                this.addActionError(messages);
            }
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "effective-crop-cycles-edit-input", "zoneTopiaId", "${zoneTopiaId}"})})
    public String execute() throws Exception {
        this.effectiveCropCycleService.updateEffectiveCropCycles(this.zoneTopiaId, this.effectiveSeasonalCropCycles, this.effectivePerennialCropCycles);
        this.notificationSupport.culturalInterventionCreated();
        return "success";
    }

    public String getZoneTopiaId() {
        return this.zoneTopiaId;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        if (Strings.isNullOrEmpty((String)zoneTopiaId) && LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("Empty zoneTopiaId. " + this.getServletInfo()));
        }
        this.zoneTopiaId = zoneTopiaId;
    }

    public Zone getZone() {
        return this.zone;
    }

    public List<EffectiveSeasonalCropCycleDto> convertEffectiveSeasonalCropCyclesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public List<EffectivePerennialCropCycleDto> convertEffectivePerennialCropCyclesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public void setEffectiveSeasonalCropCyclesJson(String json) {
        this.effectiveSeasonalCropCyclesJson = json;
    }

    public void setEffectivePerennialCropCyclesJson(String json) {
        this.effectivePerennialCropCyclesJson = json;
    }

    public Map<VineFrutalForm, String> getVineFrutalForms() {
        return this.getEnumAsMap((Object[])VineFrutalForm.values());
    }

    public Map<OrchardFrutalForm, String> getOrchardFrutalForms() {
        return this.getEnumAsMap((Object[])OrchardFrutalForm.values());
    }

    public Map<PollinatorSpreadMode, String> getPollinatorSpreadModes() {
        return this.getEnumAsMap((Object[])PollinatorSpreadMode.values());
    }

    public Map<CropCyclePhaseType, String> getPerennialPhaseTypes() {
        return this.getEnumAsMap((Object[])CropCyclePhaseType.values());
    }

    public Map<WeedType, String> getWeedTypes() {
        return this.getEnumAsMap((Object[])WeedType.values());
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        Map map = this.referentialService.getAgrosystInterventionTypeTranslationMap();
        return map;
    }

    public Map<WineValorisation, String> getWineValorisations() {
        return this.getEnumAsMap((Object[])WineValorisation.values());
    }

    public Map<PriceUnit, String> getPriceUnits() {
        return this.getEnumAsMap((Object[])PriceUnit.values());
    }

    public Map<MaterielWorkRateUnit, String> getMaterielWorkRateUnits() {
        return this.getEnumAsMap((Object[])MaterielWorkRateUnit.values());
    }

    public Map<MaterielTransportUnit, String> getMaterielTransportUnits() {
        return this.getEnumAsMap((Object[])MaterielTransportUnit.values());
    }

    public Map<CriteriaUnit, String> getCriteriaUnits() {
        return this.getEnumAsMap((Object[])CriteriaUnit.values());
    }

    public Map<PastureType, String> getPastureTypes() {
        return this.getEnumAsMap((Object[])PastureType.values());
    }

    @Generated
    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return this.effectiveCropCycleService;
    }

    @Generated
    public PlotService getPlotService() {
        return this.plotService;
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public DomainInputStockUnitService getDomainInputStockUnitService() {
        return this.domainInputStockUnitService;
    }

    @Generated
    public PricesService getPricesService() {
        return this.pricesService;
    }

    @Generated
    public Sector getGrowingSystemSector() {
        return this.growingSystemSector;
    }

    @Generated
    public Boolean getOrganic() {
        return this.organic;
    }

    @Generated
    public List<EffectiveSeasonalCropCycleDto> getEffectiveSeasonalCropCycles() {
        return this.effectiveSeasonalCropCycles;
    }

    @Generated
    public String getEffectiveSeasonalCropCyclesJson() {
        return this.effectiveSeasonalCropCyclesJson;
    }

    @Generated
    public List<EffectivePerennialCropCycleDto> getEffectivePerennialCropCycles() {
        return this.effectivePerennialCropCycles;
    }

    @Generated
    public String getEffectivePerennialCropCyclesJson() {
        return this.effectivePerennialCropCyclesJson;
    }

    @Generated
    public List<CroppingPlanEntry> getCroppingPlanEntries() {
        return this.croppingPlanEntries;
    }

    @Generated
    public String getCroppingPlanEntriesJson() {
        return this.croppingPlanEntriesJson;
    }

    @Generated
    public List<EffectiveCropCycleModelDto> getEffectiveCropCyclesMainModels() {
        return this.effectiveCropCyclesMainModels;
    }

    @Generated
    public List<EffectiveCropCycleModelDto> getEffectiveCropCyclesIntermediateModels() {
        return this.effectiveCropCyclesIntermediateModels;
    }

    @Generated
    public List<RefOrientationEDI> getRefOrientationEDIs() {
        return this.refOrientationEDIs;
    }

    @Generated
    public String getDomainId() {
        return this.domainId;
    }

    @Generated
    public int getCampaign() {
        return this.campaign;
    }

    @Generated
    public LinkedHashMap<Integer, String> getRelatedZones() {
        return this.relatedZones;
    }

    @Generated
    public Map<String, List<Pair<String, String>>> getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode() {
        return this.allCodeEspeceBotaniqueCodeQualifantBySpeciesCode;
    }

    @Generated
    public Map<String, List<Sector>> getAllsectorByCodeEspceBotaniqueCodeQualifiant() {
        return this.allsectorByCodeEspceBotaniqueCodeQualifiant;
    }

    @Generated
    public Collection<CattleDto> getCattles() {
        return this.cattles;
    }

    @Generated
    public void setZone(Zone zone) {
        this.zone = zone;
    }

    @Generated
    public void setGrowingSystemSector(Sector growingSystemSector) {
        this.growingSystemSector = growingSystemSector;
    }

    @Generated
    public void setOrganic(Boolean organic) {
        this.organic = organic;
    }

    @Generated
    public void setEffectiveSeasonalCropCycles(List<EffectiveSeasonalCropCycleDto> effectiveSeasonalCropCycles) {
        this.effectiveSeasonalCropCycles = effectiveSeasonalCropCycles;
    }

    @Generated
    public void setEffectivePerennialCropCycles(List<EffectivePerennialCropCycleDto> effectivePerennialCropCycles) {
        this.effectivePerennialCropCycles = effectivePerennialCropCycles;
    }

    @Generated
    public void setCroppingPlanEntries(List<CroppingPlanEntry> croppingPlanEntries) {
        this.croppingPlanEntries = croppingPlanEntries;
    }

    @Generated
    public void setCroppingPlanEntriesJson(String croppingPlanEntriesJson) {
        this.croppingPlanEntriesJson = croppingPlanEntriesJson;
    }

    @Generated
    public void setEffectiveCropCyclesMainModels(List<EffectiveCropCycleModelDto> effectiveCropCyclesMainModels) {
        this.effectiveCropCyclesMainModels = effectiveCropCyclesMainModels;
    }

    @Generated
    public void setEffectiveCropCyclesIntermediateModels(List<EffectiveCropCycleModelDto> effectiveCropCyclesIntermediateModels) {
        this.effectiveCropCyclesIntermediateModels = effectiveCropCyclesIntermediateModels;
    }

    @Generated
    public void setRefOrientationEDIs(List<RefOrientationEDI> refOrientationEDIs) {
        this.refOrientationEDIs = refOrientationEDIs;
    }

    @Generated
    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    @Generated
    public void setCampaign(int campaign) {
        this.campaign = campaign;
    }

    @Generated
    public void setRelatedZones(LinkedHashMap<Integer, String> relatedZones) {
        this.relatedZones = relatedZones;
    }

    @Generated
    public void setAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode(Map<String, List<Pair<String, String>>> allCodeEspeceBotaniqueCodeQualifantBySpeciesCode) {
        this.allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = allCodeEspeceBotaniqueCodeQualifantBySpeciesCode;
    }

    @Generated
    public void setAllsectorByCodeEspceBotaniqueCodeQualifiant(Map<String, List<Sector>> allsectorByCodeEspceBotaniqueCodeQualifiant) {
        this.allsectorByCodeEspceBotaniqueCodeQualifiant = allsectorByCodeEspceBotaniqueCodeQualifiant;
    }

    @Generated
    public void setCattles(Collection<CattleDto> cattles) {
        this.cattles = cattles;
    }
}

