/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.web.actions.domains.WeatherStationDto;

public class WeatherStations {
    static Function<WeatherStation, WeatherStationDto> getFunctionWeatherStationToDto(String defaultWeatherStationId) {
        return input -> {
            WeatherStationDto dto = new WeatherStationDto();
            String topiaId = input.getTopiaId();
            dto.setTopiaId(topiaId);
            dto.setRefStationMeteoTopiaId(input.getRefStationMeteo().getTopiaId());
            dto.setComment(input.getComment());
            dto.setData(input.getData());
            if (Strings.isNullOrEmpty((String)defaultWeatherStationId)) {
                dto.setDefaultSelected(false);
            } else {
                boolean defaultSelected = topiaId.equals(defaultWeatherStationId);
                dto.setDefaultSelected(defaultSelected);
            }
            return dto;
        };
    }

    protected static void dtoToWeatherStation(WeatherStationDto dto, WeatherStation weatherStation, RefStationMeteo refStationMeteo) {
        Preconditions.checkNotNull((Object)dto);
        Preconditions.checkNotNull((Object)weatherStation);
        Preconditions.checkNotNull((Object)refStationMeteo);
        weatherStation.setRefStationMeteo(refStationMeteo);
        weatherStation.setComment(dto.getComment());
        weatherStation.setData(dto.getData());
    }
}

