/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class DomainsExportEdaplos
extends AbstractAgrosystAction {
    private static final Log LOGGER = LogFactory.getLog(DomainsExportEdaplos.class);
    private static final long serialVersionUID = 1928633755050334578L;
    protected transient EdaplosService edaplosService;
    protected String edaplosFileId;

    public void setEdaplosService(EdaplosService domainService) {
        this.edaplosService = domainService;
    }

    public void setEdaplosFileId(String edaplosFileId) {
        this.edaplosFileId = edaplosFileId;
    }

    @Action(results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = this.edaplosService.exportCSVEdaplosReport(this.edaplosFileId);
        }
        catch (Exception ex) {
            this.sendFeedback(ex);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Can't generate csv", (Throwable)ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", (Throwable)ex);
        }
        return inputStream;
    }

    protected void sendFeedback(Exception ex) {
        try {
            this.edaplosService.sendExceptionFeedbackEmail(this.edaplosFileId, ex, "Export Edaplos");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFilename() {
        return "edaplos-result-report.csv";
    }
}

