/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name={"success"}, type="redirectAction", params={"namespace", "/auth", "actionName", "login-input", "email", "${email}", "actionMessage", "${actionMessage}", "next", "${next}"}), @Result(name={"error"}, type="redirectAction", params={"namespace", "/auth", "actionName", "retrieve-password-input", "token", "${token}", "userId", "${userId}"})})
public class RetrievePassword
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 3501789225489989672L;
    protected transient UserService userService;
    private String userId;
    private String token;
    private String password;
    private String passwordCheck;
    private UserDto user;
    private String actionMessage;
    private String email;
    private String next;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordCheck(String passwordCheck) {
        this.passwordCheck = passwordCheck;
    }

    public String getActionMessage() {
        return this.actionMessage;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    @Action(value="retrieve-password-input")
    public String input() throws Exception {
        this.initForInput();
        return super.input();
    }

    protected void initForInput() {
        this.user = this.userService.preparePasswordChange(this.token, this.userId);
        if (this.user == null) {
            this.addActionError("Token invalide");
        }
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.password)) {
            this.addFieldError("password", "Le mot de passe est obligatoire");
        } else if (!this.password.equals(this.passwordCheck)) {
            this.addFieldError("passwordCheck", "Les mots de passe entr\u00e9s ne correspondent pas");
        }
        if (this.hasErrors()) {
            this.initForInput();
        }
    }

    public String execute() throws Exception {
        UserDto userDto = this.userService.updatePassword(this.token, this.userId, this.password);
        if (userDto != null) {
            this.actionMessage = "Mot de passe mis \u00e0 jour, merci de vous reconnecter";
            this.email = userDto.getEmail();
            return "success";
        }
        this.input();
        return "input";
    }

    public UserDto getUser() {
        return this.user;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getToken() {
        return this.token;
    }
}

