/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class MaintenanceModeEdit
extends AbstractAdminAction {
    private static final long serialVersionUID = 1L;
    protected boolean active;
    protected String message;
    protected boolean disconnectAllUsers;
    protected int connectedUsersNb;

    @Action(value="maintenance-mode-edit-input")
    public String input() throws Exception {
        this.checkIsAdmin();
        this.active = this.authorizationService.isInMaintenanceMode();
        this.message = this.authorizationService.getMaintenanceModeMessage();
        this.disconnectAllUsers = this.authorizationService.mustDisconnetAllUsers();
        this.connectedUsersNb = this.computeConnectedUsersCount().uniqueUsersCount();
        return super.input();
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "maintenance-mode-edit-input"})})
    public String execute() throws Exception {
        this.checkIsAdmin();
        if (!this.active) {
            this.message = null;
            this.disconnectAllUsers = false;
        } else {
            this.message = this.message.replaceAll("(\\n|\\r)+", "<br/>");
        }
        this.authorizationService.setMaintenanceMode(this.active, this.message, this.disconnectAllUsers);
        return "success";
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDisconnectAllUsers() {
        return this.disconnectAllUsers;
    }

    public void setDisconnectAllUsers(boolean disconnectAllUsers) {
        this.disconnectAllUsers = disconnectAllUsers;
    }

    public int getConnectedUsersNb() {
        return this.connectedUsersNb;
    }
}

