/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions;

import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionInvocation;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.result.StrutsResultSupport;

public class AgrosystJsonResultSupport
extends StrutsResultSupport {
    private static final long serialVersionUID = 4604320651695670319L;
    private static final Log LOGGER = LogFactory.getLog(AgrosystJsonResultSupport.class);
    protected transient Gson gson;

    public Gson getGson() {
        if (this.gson == null) {
            this.gson = new AgrosystGsonSupplier().get();
        }
        return this.gson;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) {
        block6: {
            Object jsonData = invocation.getStack().findValue("jsonData");
            String json = this.getGson().toJson(jsonData);
            HttpServletRequest servletRequest = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            HttpServletResponse servletResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            if (invocation.getResultCode().equals("error")) {
                Integer httpCode = (Integer)invocation.getStack().findValue("httpCode");
                if (httpCode == null) {
                    httpCode = 500;
                }
                servletResponse.setStatus(httpCode.intValue());
            }
            servletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String acceptHeader = servletRequest.getHeader("accept");
            if (acceptHeader == null || acceptHeader.contains("application/json")) {
                servletResponse.setContentType("application/json");
            } else {
                servletResponse.setContentType("text/plain");
            }
            try {
                ServletOutputStream outputStream = servletResponse.getOutputStream();
                byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
                outputStream.write(jsonBytes);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block6;
                LOGGER.error((Object)"Unable to write JSON output into Servlet Response");
            }
        }
    }
}

