/*-
 * #%L
 * Agrosyst :: Web
 * %%
 * Copyright (C) 2013 - 2020 INRAE, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
angular.module('ui.switch', [])
.directive('switch', function(){
  return {
    restrict: 'AE',
    replace: true,
    transclude: true,
    template: function(element, attrs) {
      var html = '<div class="';
      if (attrs.struts) {
          html += 'wwgrp '
      }
      if (attrs.class) {
        html += attrs.class;
      }
      html += '">';
      if (attrs.label) {
        html += '<span class="';
        if (attrs.struts) {
            html += 'wwlbl '
        }
        if (attrs.class) {
          html += attrs.class;
        }
        html += '">';
        html += '<label class="label';
        if (attrs.class) {
          html += ' ' + attrs.class;
        }
        html += '">'+ attrs.label + '</label>'
        html += '</span>';
      }
      if (attrs.struts) {
        html += '<span class="wwctrl">';
      }
      if (attrs.help) {
        html += '<span class="tooltip-ng help"><i class="icon float-right fa fa-question-circle" aria-hidden="true"></i><span class="tooltip-hover">' + attrs.help + '</span></span>';
      }
      html += '<span class="switch';
      if (attrs.class) {
        html += ' ' + attrs.class;
      }
      html += '"';
      if (attrs.ngModel) {
        html += ' ng-click="(' + attrs.disabled + ') ? ' + attrs.ngModel + ' : ' + attrs.ngModel + '=!' + attrs.ngModel;
        if (attrs.ngChange) {
          html += '; ' + attrs.ngChange + '()';
        }
        html += '"';
      }
      html +=   ' ng-class="{ checked:' + attrs.ngModel + ', disabled:' + attrs.disabled + ' }"';
      html +=   '>';
      html +=   '<small></small>';
      html +=   '<input type="checkbox"';
      if (attrs.id) {
        html += ' id="' + attrs.id + '"';
      }
      if (attrs.name) {
        html += ' name="' + attrs.name + '"';
      }
      if (attrs.ngModel) {
        html += ' ng-model="' + attrs.ngModel + '"';
      }
      html +=     ' style="display:none" value="true"/>';
      html +=     '<span class="switch-text">'; /*adding new container for switch text*/
      if (attrs.on) {
        html += '<span class="on">' + attrs.on + '</span>'; /*switch text on value set by user in directive html markup*/
      }
      if (attrs.off) {
        html += '<span class="off">' + attrs.off + '</span>'; /*switch text off value set by user in directive html markup*/
      }
      html += '</span>';
      if (attrs.struts) {
        html += '</span>';
      }
      html += '</div>';
      return html;
    }
  }
})
.directive('switchThree', function() {
  return {
    restrict: 'AE',
    replace: true,
    transclude: true,
    scope: {
      ngModel: '=',
      values: '=',
      labels: '='
    },
    template: function(element, attrs) {
      var html = '<div class="switch switch-three';
      if (attrs.class) html += ' ' + attrs.class;
      html += '" ng-click="nextValue()" ';
      html += 'ng-class="{disabled: ' + attrs.disabled + ', ';
      if(attrs.pos0off ) {
        html += 'pos0off: ngModel === values[0], ';
        html += 'pos0off: ngModel === values[0], ';
      } else {
        html += 'pos0: ngModel === values[0], ';
        html += 'pos0: ngModel === values[0], ';
      }
      html += 'pos1: ngModel === values[1], ';
      html += 'pos2: ngModel === values[2]';
      html += '}">';
      html += '<small></small>';
      html += '<span class="switch-label">{{ getLabel() }}</span>';
      html += '<input type="hidden" name="' + (attrs.name || '') + '" ng-value="ngModel" />';
      html += '</div>';
      return html;
    },
    link: function(scope, element, attrs) {
      scope.nextValue = function() {
        if (attrs.disabled) return;



        if(!attrs.required) {
          if (scope.ngModel === scope.values[0]) scope.ngModel = scope.values[1];
          else if (scope.ngModel === scope.values[1]) scope.ngModel = scope.values[2];
        } else {
          if(scope.ngModel == undefined) scope.ngModel = scope.values[2];
          else if (attrs.required && scope.ngModel === scope.values[0]) scope.ngModel = scope.values[2];
          else if (!attrs.required && scope.ngModel === scope.values[0]) scope.ngModel = scope.values[1];
          else scope.ngModel = scope.values[0];
        }

        if (attrs.ngChange) {
          scope.$eval(attrs.ngChange);
        }
      };

      scope.getLabel = function() {
        if (scope.labels && scope.labels.length == 3) {
          if (scope.ngModel === scope.values[0]) return scope.labels[0];
          if (scope.ngModel === scope.values[1]) return scope.labels[1];
          if (scope.ngModel === scope.values[2]) return scope.labels[2];
        }
        return '';
      };
    }
  };
});
