<%--
  #%L
  Agrosyst :: Web
  $Id$
  $HeadURL$
  %%
  Copyright (C) 2013 - 2014 INRA
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-3.0.html>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" session="false" %>
<%@ taglib uri="/struts-tags" prefix="s" %>

<!--practiced-systems-edit-input-seasonal.jsp-->

<div ng-controller="PracticedSeasonalCropCycleNodeController" id="tab_1">

  <div>

    <s:hidden name="practicedSeasonalCropCycleDtosJson" value="{{seasonalCropCycles}}"/>

    <div ng-if="!croppingPlanModel.length">
      Le système synthétisé ne contient aucune culture principale ou dérobée associée au domaine pour les campagnes sélectionnées.
      Vous devez modifier votre saisie pour pouvoir dessiner la rotation de cultures assolées.
    </div>

    <fieldset style="margin-bottom: 0px;">

      <s:if test="practicedSystem.growingSystem != null">
        <div class="help-explanation">
          Cultures du domaine <s:property value="practicedSystem.growingSystem.growingPlan.domain.name" />
          <s:if test="practicedSystem.campaigns != null">pour la(es) campagne(s) <s:property value="practicedSystem.campaigns" /></s:if> :
        </div>
      </s:if>
      <div id="diagram">
        <div id="cropCycleDiagramDiv"></div>
      </div>

      <div ng-show="seasonalCropCycles && seasonalCropCycles.length>0 && seasonalCropCycles[0].cropCycleNodeDtos.length > 0" class="clearfix">
        <a ng-click="toggleGraphInfo(true)" class="btn" style="display: none;" id="graphInfosShow">Afficher les informations des connexions</a>
        <a ng-click="toggleGraphInfo(false)" class="btn" id="graphInfosHide">Masquer les informations des connexions</a>
      </div>

      <!-- Noeud sélectionné -->
      <div ng-if="selectedCropCycleNode" id="croppingPlanEntry" class="sub-form marginTop30">
        <div id="croppingPlanEntryDetails" class="sub-form-content">
          <a ng-click="deleteCropCycleNode(selectedCropCycleNode, true)" class="btn delete-button float-right">Supprimer la culture
            <div class="btn-icon icon-delete" style="padding : 0px;"> </div>
          </a>

          <div class="noborder">
            <div class="croppingDetailsField">
              <label class="historicLabelStyle" >Culture&nbsp;:</label>
              <span class="generated-content">{{selectedCropCycleNode.label}} (rang&nbsp;{{selectedCropCycleNode.x + 1}})</span>
            </div>
            <div class="croppingDetailsField switch-div">
              <label class="historicLabelStyle" for="selectedCropCycleNodeCropEndCycle">Fin de la rotation&nbsp;:</label>
              <switch id="selectedCropCycleNodeCropEndCycle"  ng-model="selectedCropCycleNode.endCycle" ng-click="updateNode()">
              </switch>
              <span>
                     {{ selectedCropCycleNode.endCycle ? 'Oui' : 'Non' }}
              </span>
            </div>
            <div class="croppingDetailsField switch-div">
              <label class="historicLabelStyle" for="selectedCropCycleNodeSameCampaign">
                Même campagne agricole que la culture précédente&nbsp;:
              </label>
              <div class="switch-div">
                <switch ng-model="selectedCropCycleNode.sameCampaignAsPreviousNode" ng-click="updateNode()">
                </switch>
                <span>
                    {{ selectedCropCycleNode.sameCampaignAsPreviousNode ? 'Oui' : 'Non' }}
                </span>
              </div>
            </div>
            <div class="croppingDetailsField" ng-if="selectedCropCycleNode.x == 0">
              <label class="historicLabelStyle" for="selectedCropCycleNodeInitNodeFrequency">Fréquence initiale de la culture&nbsp;:</label>
              <span class="wwctrl">
                <span class="input-append">
                  <input type="text" id="selectedCropCycleNodeInitNodeFrequency" ng-model="selectedCropCycleNode.initNodeFrequency"
                  ng-change='updateNode()' ag-percent pattern="^100$|^[0-9]{1,2}$|^[0-9]{1,2}[\.,][0-9]{1,3}$" />
                  <span class="add-on">%</span>
                </span>
              </span>
            </div>
          </div>

          <!-- Liste des espèces du noeud sélectionné -->
          <div id="croppingPlanEntrySpecies" ng-if="selectedCroppingPlanEntryCode" class="paddingTop0">
            <table class="data-table full-width">
              <thead>
                <tr>
                  <th scope="col">Espèce</th>
                  <th scope="col">Qualifiant</th>
                  <th scope="col">Type saisonnier</th>
                  <th scope="col">Destination</th>
                  <th scope="col">Cépage/Variété</th>
                </tr>
              </thead>
              <tbody>
                <tr ng-show="!croppingPlanEntrySpeciesIndex || !croppingPlanEntrySpeciesIndex[selectedCroppingPlanEntryCode] || croppingPlanEntrySpeciesIndex[selectedCroppingPlanEntryCode].length == 0"><td colspan="6" class="empty-table">Aucune espèce n'est renseignée pour cette culture</td></tr>
                <tr ng-repeat="cpEntrySpecies in croppingPlanEntrySpeciesIndex[selectedCroppingPlanEntryCode]">
                  <td>{{cpEntrySpecies.speciesEspece}}</td>
                  <td>{{cpEntrySpecies.speciesQualifiant|orDash}}</td>
                  <td>{{cpEntrySpecies.speciesTypeSaisonnier|orDash}}</td>
                  <td>{{cpEntrySpecies.speciesDestination|orDash}}</td>
                  <td ng-if="cpEntrySpecies.varietyLibelle">{{ cpEntrySpecies.varietyLibelle }}</td>
                  <td ng-if="!cpEntrySpecies.varietyLibelle && cpEntrySpecies.edaplosUnknownVariety"
                      class="warning-label">
                    <i class="fa fa-warning" aria-hidden="true"></i> Variété non reconnue "{{ cpEntrySpecies.edaplosUnknownVariety }}"
                  </td>
                  <td ng-if="!cpEntrySpecies.varietyLibelle && !cpEntrySpecies.edaplosUnknownVariety">-</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Connection sélectionnée -->
      <div ng-if="selectedCropCycleConnection" id="intermediateCroppingPlanEntry" class="sub-form marginTop30">
        <div id="intermediateCroppingPlanEntryDetails" class="sub-form-content">
          <a ng-click="deleteCropCycleConnection(selectedCropCycleConnection, true)" class="btn delete-button float-right">Supprimer la connexion
            <div class="btn-icon icon-delete" style="padding : 0px;"> </div>
          </a>

          <div class="croppingDetailsField noborder">
            <label class="historicLabelStyle" for="selectedCropCycleConnectionFrequency">Fréquence&nbsp;:</label>
            <span class="wwctrl">
              <input  type="text"
                      id="selectedCropCycleConnectionFrequency"
                      style="width: 5%;"
                      ng-model="selectedCropCycleConnection.croppingPlanEntryFrequency" 
                      ag-percent pattern="^100$|^[0-9]{1,2}$|^[0-9]{1,2}[\.,][0-9]{1,3}$"
                      ng-change="updateConnection(selectedCropCycleConnection, selectedCropCycleConnection.selectedIntermediateCroppingPlanEntry)" />
              <span><b>&nbsp;%&nbsp;</b></span>
              <a id="autoFreqAdjust"
                 class="fakeButton" 
                 ng-click="updateConnection(selectedCropCycleConnection, selectedCropCycleConnection.selectedIntermediateCroppingPlanEntry, true)" 
                 title="Auto ajustement">
                <i class="fa fa-wrench font-size95" aria-hidden="true"></i>
              </a>
            </span>
          </div>

          <div class="croppingDetailsField positionRelative switch-div">
            <label class="historicLabelStyle" for="selectedCropCycleConnectionNotUsedForThisCampaign">
              Culture absente
              <span class='contextual-help-in-label'>
                <span class='help-hover'>
                  <s:text name="help.practiced-systems.cropCoupleNotUsedForThisCampaign"/>
                </span>
              </span>
              :
            </label>
            <div class="switch-div">
              <switch
                id="selectedCropCycleConnectionNotUsedForThisCampaign"
                ng-model="selectedCropCycleConnection.notUsedForThisCampaign"
                ng-click="updateConnection(selectedCropCycleConnection, selectedCropCycleConnection.selectedIntermediateCroppingPlanEntry)"
                ng-disabled="selectedCropCycleConnection.interventions.length > 0"
                ng-attr-title="{{selectedCropCycleConnection.interventions.length > 0 ? 'Des interventions existent sur cette culture' : ''}}">
              </switch>
              <span>
                {{ selectedCropCycleConnection.notUsedForThisCampaign ? 'Oui' : 'Non' }}
              </span>
            </div>
          </div>

          <div class="croppingDetailsField">
            <label class="historicLabelStyle" style="margin:10px;" for="selectedCropCycleConnectionIntermediateCroppingPlanEntry">Culture intermédiaire&nbsp;:</label>
            <select id="selectedCropCycleConnectionIntermediateCroppingPlanEntry"
                ng-model="selectedCropCycleConnection.selectedIntermediateCroppingPlanEntry"
                ng-options="item as item.label for item in intermediateCroppingPlanModel"
                ng-change="setSelectedIntermediateCroppingPlanEntryChange()"
                style="margin:10px;">
              <option value=""></option>
            </select>
          </div>
        </div>
      </div>

      <div class="help-explanation-panel">
       <s:text name="help.practicedSystem.seasonal.drawing" />
      </div>
      <a ng-click="deletePracticedSeasonalCropCycleDto()" class="btn delete-button" style="margin-left:0px;">Supprimer la rotation<div class="btn-icon icon-delete"> </div></a>

      <div id="confirmSeasonalCropChange" title="Le changement de culture sera répercuté dans l'onglet 'Itinéraire technique'." class="auto-hide">
        <span>
          <p ng-bind-html="seasonalCropChangeContext.warningMessages"></p>
        </span>
      </div>

      <div id="confirmRemovedSeasonalCycle" title="Suppression de la rotation" class="auto-hide">
        Etes-vous sûr(e) de vouloir supprimer la rotation&nbsp;?
      </div>

    </fieldset>
  </div>
</div>
