/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.performances;

import fr.inra.agrosyst.api.entities.performance.IndicatorFilter;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.Categories;
import fr.inra.agrosyst.api.entities.performance.indicators.gestim.Modalities;
import fr.inra.agrosyst.services.performance.indicators.ComputedIndicator;
import fr.inra.agrosyst.services.performance.indicators.activesubstances.IndicatorActiveSubstanceAmount;
import fr.inra.agrosyst.services.performance.indicators.alerts.IndicatorAlertIFT;
import fr.inra.agrosyst.services.performance.indicators.expenses.operatingexpenses.IndicatorDecomposedOperatingExpenses;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorMineralFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorOrganicFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorTotalFertilization;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorEnergieTotale;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorFuelEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorGESTotaux;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorMineralFertilizationEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorOrganicFertilisationEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorPATotaux;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorPhytoEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorSeedingEmissions;
import fr.inra.agrosyst.services.performance.indicators.gestim.IndicatorSeedingTreatmentEmissions;
import fr.inra.agrosyst.services.performance.indicators.ift.IndicatorLegacyIFT;
import fr.inra.agrosyst.services.performance.indicators.ift.IndicatorRefMaxYearCropIFT;
import fr.inra.agrosyst.services.performance.indicators.ift.IndicatorRefMaxYearTargetIFT;
import fr.inra.agrosyst.services.performance.indicators.ift.IndicatorVintageCropIFT;
import fr.inra.agrosyst.services.performance.indicators.ift.IndicatorVintageTargetIFT;
import fr.inra.agrosyst.services.performance.indicators.organicproducts.IndicatorOrganicProducts;
import fr.inra.agrosyst.services.performance.indicators.productsandmargins.IndicatorGrossIncome;
import fr.inra.agrosyst.services.performance.indicators.productsandmargins.IndicatorStandardisedGrossIncome;
import fr.inra.agrosyst.web.rest.performances.Indicator;
import fr.inra.agrosyst.web.rest.performances.IndicatorUtils;
import fr.inra.agrosyst.web.rest.performances.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class IndicatorUtils {
    static final Function<Set<Method>, List<Class<? extends ComputedIndicator>>> PRODUIT_ET_MARGES_PARAMETER = methods -> {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (methods.contains(Method.PRIX_REELS_PRODUITS_MARGES)) {
            classes.add(IndicatorGrossIncome.class);
        }
        if (methods.contains(Method.PRIX_STANDARDISES_MILLESIMES_PRODUITS_MARGES)) {
            classes.add(IndicatorStandardisedGrossIncome.class);
        }
        return classes;
    };
    static final Function<Set<Method>, List<Class<? extends ComputedIndicator>>> IFT_INDICATORS_PARAMETER = methods -> {
        ArrayList<Class<IndicatorLegacyIFT>> classes = new ArrayList<Class<IndicatorLegacyIFT>>();
        if (methods.contains(Method.IFT_A_LA_CIBLE_NON_MILLESIME)) {
            classes.add(IndicatorRefMaxYearTargetIFT.class);
        }
        if (methods.contains(Method.IFT_A_LA_CIBLE_MILLESIME)) {
            classes.add(IndicatorVintageTargetIFT.class);
        }
        if (methods.contains(Method.IFT_A_LA_CULTURE_NON_MILLESIME)) {
            classes.add(IndicatorRefMaxYearCropIFT.class);
        }
        if (methods.contains(Method.IFT_A_LA_CULTURE_MILLESIME)) {
            classes.add(IndicatorVintageCropIFT.class);
        }
        if (methods.contains(Method.IFT_A_L_ANCIENNE_NON_MILLESIME)) {
            classes.add(IndicatorLegacyIFT.class);
        }
        return classes;
    };

    IndicatorUtils() {
    }

    static Set<Indicator> CONVERT_TO_INDICATORS(Collection<IndicatorFilter> filters) {
        if (filters != null) {
            HashSet<Indicator> indicators = new HashSet<Indicator>();
            Set indicatorsWithClazz = Arrays.stream(Indicator.values()).filter(indicator -> indicator.getDoe().isEmpty()).filter(indicator -> indicator.getIft().isEmpty()).filter(indicator -> indicator.getClazz().isPresent()).collect(Collectors.toSet());
            filters.forEach(filter -> {
                String className = filter.getClazz();
                if (IndicatorDecomposedOperatingExpenses.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getDoe().isPresent()).filter(indicator -> filter.getDoeIndicators().contains(indicator.getDoe().get())).collect(Collectors.toSet()));
                } else if (IndicatorLegacyIFT.class.getSimpleName().equals(className) || IndicatorRefMaxYearTargetIFT.class.getSimpleName().equals(className) || IndicatorVintageTargetIFT.class.getSimpleName().equals(className) || IndicatorRefMaxYearCropIFT.class.getSimpleName().equals(className) || IndicatorVintageCropIFT.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getIft().isPresent()).filter(indicator -> filter.getIfts().contains(indicator.getIft().get())).collect(Collectors.toSet()));
                } else if (IndicatorMineralFertilization.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getMineralFertilization().isPresent()).filter(indicator -> filter.getMineralFertilizations().contains(indicator.getMineralFertilization().get())).collect(Collectors.toSet()));
                } else if (IndicatorOrganicFertilization.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getOrganicFertilization().isPresent()).filter(indicator -> filter.getOrganicFertilizations().contains(indicator.getOrganicFertilization().get())).collect(Collectors.toSet()));
                } else if (IndicatorTotalFertilization.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getTotalFertilization().isPresent()).filter(indicator -> filter.getTotalFertilizations().contains(indicator.getTotalFertilization().get())).collect(Collectors.toSet()));
                } else if (IndicatorActiveSubstanceAmount.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getActiveSubstance().isPresent()).filter(indicator -> filter.getActiveSubstances().contains(indicator.getActiveSubstance().get())).collect(Collectors.toSet()));
                } else if (IndicatorOrganicProducts.class.getSimpleName().equals(className)) {
                    indicators.addAll(Arrays.stream(Indicator.values()).filter(indicator -> indicator.getOrganicProduct().isPresent()).filter(indicator -> filter.getOrganicProducts().contains(indicator.getOrganicProduct().get())).collect(Collectors.toSet()));
                } else if (IndicatorGESTotaux.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_TOTAUX);
                    }
                } else if (IndicatorPATotaux.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_TOTAUX);
                    }
                } else if (IndicatorEnergieTotale.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_TOTAL);
                    }
                } else if (IndicatorMineralFertilizationEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_FERTILISANTS_MINERAUX);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_FERTILISANTS_MINERAUX);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_FERTILISANTS_MINERAUX);
                    }
                } else if (IndicatorOrganicFertilisationEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_FERTILISANTS_ORGANIQUES);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_FERTILISANTS_ORGANIQUES);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_FERTILISANTS_ORGANIQUES);
                    }
                } else if (IndicatorPhytoEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_PRODUITS_PHYTOSANITAIRE);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_PRODUITS_PHYTOSANITAIRE);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_PRODUITS_PHYTOSANITAIRE);
                    }
                } else if (IndicatorSeedingTreatmentEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_TRAITEMENTS_SEMENCES);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_TRAITEMENTS_SEMENCES);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_TRAITEMENTS_SEMENCES);
                    }
                } else if (IndicatorSeedingEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_SEMENCES_ET_PLANTS);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_SEMENCES_ET_PLANTS);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        indicators.add(Indicator.ENERGIE_SEMENCES_ET_PLANTS);
                    }
                } else if (IndicatorFuelEmissions.class.getSimpleName().equals(className)) {
                    Collection categories = filter.getCategories();
                    if (categories.contains(Categories.GES)) {
                        indicators.add(Indicator.GES_CARBURANT);
                    }
                    if (categories.contains(Categories.PA)) {
                        indicators.add(Indicator.POLLUANTS_ATMOSPHERIQUES_CARBURANT);
                    }
                    if (categories.contains(Categories.ENERGIE)) {
                        if (filter.getModalities().contains(Modalities.ENERGIE_DIRECTES)) {
                            indicators.add(Indicator.ENERGIE_CARBURANT_DIRECT);
                        }
                        if (filter.getModalities().contains(Modalities.ENERGIE_INDIRECTES)) {
                            indicators.add(Indicator.ENERGIE_CARBURANT_INDIRECT);
                        }
                    }
                } else if (IndicatorAlertIFT.class.getSimpleName().equals(className)) {
                    HashSet alertIftIdicators = new HashSet();
                    CollectionUtils.emptyIfNull((Collection)filter.getIfts()).forEach(ift -> {
                        switch (1.$SwitchMap$fr$inra$agrosyst$api$entities$performance$Ift[ift.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                break;
                            }
                            case 7: {
                                alertIftIdicators.add(Indicator.ALERTE_IFT_CHIMIQUE_TOTAL_HTS);
                                break;
                            }
                            case 8: {
                                alertIftIdicators.add(Indicator.ALERTE_IFT_HERBICIDE);
                                break;
                            }
                            case 9: {
                                alertIftIdicators.add(Indicator.ALERTE_IFT_FONGICIDE);
                                break;
                            }
                            case 10: {
                                alertIftIdicators.add(Indicator.ALERTE_IFT_INSECTICIDE);
                                break;
                            }
                            case 11: {
                                alertIftIdicators.add(Indicator.ALERTE_IFT_TOTAL_CHIMIQUE_HTS_BIOCONTROLE);
                            }
                        }
                    });
                    indicators.addAll(alertIftIdicators);
                } else {
                    indicatorsWithClazz.stream().filter(indicator -> indicator.getClazz().isPresent()).filter(indicator -> className.equals(((Class)indicator.getClazz().get()).getSimpleName())).findFirst().ifPresent(indicators::add);
                }
                if (IndicatorGrossIncome.class.getSimpleName().equals(className) || IndicatorStandardisedGrossIncome.class.getSimpleName().equals(className)) {
                    indicators.add(Indicator.PRODUIT_BRUT);
                }
            });
            return indicators;
        }
        return Collections.emptySet();
    }
}

