/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.networks;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkImpl;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.network.NetworkIndicators;
import fr.inra.agrosyst.api.services.network.NetworkManagerDto;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class NetworksEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(NetworksEdit.class);
    private static final long serialVersionUID = -4466666585810184117L;
    protected transient NetworkService networkService;
    protected transient UserService userService;
    protected String networkTopiaId;
    protected Network network;
    protected String parentIds;
    protected List<NetworkManagerDto> managers;
    protected String managersJson;
    protected NetworkIndicators indicators;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void prepare() {
        if (StringUtils.isBlank((CharSequence)this.networkTopiaId)) {
            this.network = this.networkService.newNetwork();
        } else {
            this.network = this.networkService.getNetwork(this.networkTopiaId);
            this.activated = this.network.isActive();
        }
    }

    protected void initForInput() {
        this.indicators = this.networkService.getIndicators(this.networkTopiaId);
    }

    @Action(value="networks-edit-input")
    public String input() {
        this.initForInput();
        if (!StringUtils.isBlank((CharSequence)this.networkTopiaId)) {
            boolean bl = this.readOnly = !this.authorizationService.isNetworkWritable(this.network);
            if (this.readOnly) {
                this.notificationSupport.networkNotWritable();
            }
        }
        this.managers = this.getNetworkManagersDtos(this.network);
        return "input";
    }

    protected List<NetworkManagerDto> getNetworkManagersDtos(Network network) {
        ArrayList<NetworkManagerDto> managers = new ArrayList<NetworkManagerDto>();
        for (NetworkManager networkManager : network.getManagers()) {
            String userTopiaId = networkManager.getAgrosystUser().getTopiaId();
            UserDto userDto = this.userService.getUser(userTopiaId);
            NetworkManagerDto result = new NetworkManagerDto(networkManager.getTopiaId(), networkManager.getFromDate(), networkManager.getToDate(), Boolean.valueOf(networkManager.isActive()), userDto);
            managers.add(result);
        }
        return managers;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.network.getName())) {
            this.addFieldError("name", "Le nom du r\u00e9seau est obligatoire.");
        } else {
            Set homonymeNetworks = this.networkService.findNetworksByName(this.network.getName(), this.networkTopiaId);
            if (homonymeNetworks != null && !homonymeNetworks.isEmpty() && !homonymeNetworks.contains(this.networkTopiaId)) {
                this.addFieldError("name", "Le nom du r\u00e9seau est d\u00e9j\u00e0 utilis\u00e9.");
            }
        }
        if (this.network.isPersisted() && !this.network.isActive()) {
            this.addActionError("Vous ne pouvez enregistrer le r\u00e9seau car il est inactif. Veuillez le r\u00e9activer \u00e0 partir de la liste des r\u00e9seaux.");
        }
        try {
            this.managers = this.convertNetworkManagerDtoJson(this.managersJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)ex);
            }
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant les responsables de r\u00e9seau n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
            this.managers = this.getNetworkManagersDtos(this.network);
        }
        if (this.managers.isEmpty()) {
            this.addFieldError("user", "Un r\u00e9seau doit avoir au moins un responsable.");
        }
        try {
            if (this.researchParentsCycleProcess().booleanValue()) {
                this.addFieldError("parent", "Cycle d\u00e9tect\u00e9, un r\u00e9seau ne peut avoir lui-m\u00eame comme parent ou un r\u00e9seau parent ayant ce r\u00e9seau comme parent.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)e);
            }
            this.addFieldError("parent", "Cycle d\u00e9tect\u00e9, un r\u00e9seau ne peut avoir lui-m\u00eame comme parent ou un r\u00e9seau parent ayant ce r\u00e9seau comme parent.");
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : network:'%s' -> %s", this.networkTopiaId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : network:'%s' -> %s", this.networkTopiaId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    protected Boolean researchParentsCycleProcess() {
        Boolean result = false;
        List parentIds = this.getParentTopiaIds();
        for (String parentId : parentIds) {
            Network parent = this.networkService.getNetwork(parentId);
            result = this.researchCycle(parent);
        }
        return result;
    }

    protected Boolean researchCycle(Network parent) {
        Boolean result = false;
        if (this.networkTopiaId.equals(parent.getTopiaId())) {
            result = true;
        } else {
            for (Network grandParent : parent.getParents()) {
                result = this.researchCycle(grandParent);
            }
        }
        return result;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "networks-edit-input", "networkTopiaId", "${network.topiaId}"})})
    public String execute() throws Exception {
        try {
            this.network = this.networkService.createOrUpdateNetwork(this.network, (Collection)this.managers, this.getParentTopiaIds());
            this.notificationSupport.networkSaved(this.network);
            if (Strings.isNullOrEmpty((String)this.networkTopiaId)) {
                this.navigationContextEntityCreated((TopiaEntity)this.network);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to save network '%s', '%s', '%s':", this.network, this.managers, this.parentIds), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public String getNetworkTopiaId() {
        return this.networkTopiaId;
    }

    public void setNetworkTopiaId(String networkTopiaId) {
        this.networkTopiaId = networkTopiaId;
    }

    public List<String> getParentIds() {
        List result;
        block2: {
            result = null;
            try {
                result = this.getParentTopiaIds();
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)String.format("Failed to deserialize parentIds '%s'", this.parentIds), (Throwable)e);
            }
        }
        return result;
    }

    public void setParentIdsJson(String json) {
        this.parentIds = json;
    }

    protected List<String> getParentTopiaIds() {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List result = (List)this.getGson().fromJson(this.parentIds, type);
        return result;
    }

    public Network getNetwork() {
        return Objects.requireNonNullElseGet(this.network, NetworkImpl::new);
    }

    public List<NetworkManagerDto> convertNetworkManagerDtoJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List managers = (List)this.getGson().fromJson(json, type);
        return managers;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public List<NetworkManagerDto> getManagers() {
        return this.managers;
    }

    public void setNetworkManagerDtoJson(String json) {
        this.managersJson = json;
    }

    public NetworkIndicators getIndicators() {
        return this.indicators;
    }

    public Map<TypeDEPHY, String> getTypesDephy() {
        return this.getEnumAsMap((Object[])new TypeDEPHY[]{TypeDEPHY.DEPHY_FERME, TypeDEPHY.DEPHY_EXPE, TypeDEPHY.NOT_DEPHY});
    }
}

