/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.itk;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.InputType;
import fr.inra.agrosyst.api.entities.MineralProductUnit;
import fr.inra.agrosyst.api.entities.OrganicProductUnit;
import fr.inra.agrosyst.api.entities.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.PotInputUnit;
import fr.inra.agrosyst.api.entities.SubstrateInputUnit;
import fr.inra.agrosyst.api.entities.action.CapacityUnit;
import fr.inra.agrosyst.api.entities.action.FertiOrgaUnit;
import fr.inra.agrosyst.api.entities.action.SeedPlantUnit;
import fr.inra.agrosyst.api.entities.action.SeedType;
import fr.inra.agrosyst.api.entities.action.YealdCategory;
import fr.inra.agrosyst.api.entities.referential.BioAgressorParentType;
import fr.inra.agrosyst.api.entities.referential.ProductType;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFAAbstract;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.referential.GroupeCibleDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.commons.FrontCreateOrUpdateErrors;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public abstract class AbstractItkAction
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -6057182538439163217L;
    protected transient ReferentialService referentialService;
    protected transient ActionService actionService;
    protected transient List<GroupeCibleDTO> groupesCibles;
    protected static final String WRONG_DESTINATION_MESSAGE = "Vous avez une destination de r\u00e9colte import\u00e9e par d\u00e9faut depuis eDaplos, pour la culture %s. Merci de corriger cette destination ainsi que le rendement correspondant (valeur et unit\u00e9).";

    public final void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected void initForInput() {
        this.groupesCibles = this.referentialService.getGroupesCibles();
        super.initForInput();
    }

    protected boolean hasErrors(FrontCreateOrUpdateErrors validationErrors) {
        validationErrors.getFieldErrors().forEach((arg_0, arg_1) -> ((AbstractItkAction)this).addFieldError(arg_0, arg_1));
        validationErrors.getErrorMessages().forEach(arg_0 -> ((AbstractItkAction)this).addActionError(arg_0));
        return this.hasErrors();
    }

    public Map<YealdCategory, String> getYealdCategories() {
        return this.getEnumAsMap((Object[])YealdCategory.values());
    }

    public Map<CapacityUnit, String> getCapacityUnits() {
        return this.getEnumAsMap((Object[])CapacityUnit.values());
    }

    public Map<BioAgressorType, BioAgressorParentType> getTreatmentTargetCategoriesByParent() {
        Map<BioAgressorType, BioAgressorParentType> result = Referentials.getTreatmentTargetBioAgressorParentTypes().stream().collect(Collectors.toMap(BioAgressorParentType::getParent, Function.identity()));
        return result;
    }

    public Map<BioAgressorType, String> getTreatmentTargetCategories() {
        Map enumTranslationMap = this.referentialService.getTranslatedBioAgressorType();
        Map<BioAgressorType, String> treatmentTargetCategories = Referentials.getTreatmentTargetBioAgressorParentTypes().stream().map(BioAgressorParentType::getParent).collect(Collectors.toMap(Function.identity(), enumTranslationMap::get));
        return treatmentTargetCategories;
    }

    public Map<SeedType, String> getSeedTypes() {
        Map enumTranslationMap = this.i18nService.getEnumTranslationMap(SeedType.class);
        return enumTranslationMap;
    }

    public Map<SeedPlantUnit, String> getSeedPlantUnits() {
        return this.getEnumAsMap((Object[])SeedPlantUnit.values());
    }

    public Map<MineralProductUnit, String> getMineralProductUnits() {
        return this.getEnumAsMap((Object[])MineralProductUnit.values());
    }

    public Map<OrganicProductUnit, String> getOrganicProductUnits() {
        return this.getEnumAsMap((Object[])OrganicProductUnit.values());
    }

    public Map<PhytoProductUnit, String> getPhytoProductUnits() {
        return this.getEnumAsMap((Object[])PhytoProductUnit.values());
    }

    public Map<ProductType, String> getProductTypes() {
        return this.getEnumAsMap((Object[])ProductType.values());
    }

    public Map<FertiOrgaUnit, String> getFertiOrgaUnits() {
        return this.getEnumAsMap((Object[])FertiOrgaUnit.values());
    }

    public Map<InputType, String> getInputTypesLabels() {
        return this.getEnumAsMap((Object[])InputType.values());
    }

    public Map<SubstrateInputUnit, String> getSubstrateInputUnits() {
        return this.getEnumAsMap((Object[])SubstrateInputUnit.values());
    }

    public Map<PotInputUnit, String> getPotInputUnits() {
        return this.getEnumAsMap((Object[])PotInputUnit.values());
    }

    public Map<String, String> getMineralProductElementNamesAndLibelles() {
        Field[] champs = RefFertiMinUNIFAAbstract.class.getDeclaredFields();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Field champ : champs) {
            String propertyName = champ.getName();
            String libelle = this.getText(RefFertiMinUNIFAAbstract.class.getName() + "." + propertyName);
            if (libelle.startsWith(RefFertiMinUNIFAAbstract.class.getName())) continue;
            result.put(propertyName, libelle);
        }
        return result;
    }

    public String getDefaultDestinationName() {
        String result = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{I18n.t((String)"prices-harvest-table-toComplete", (Object[])new Object[0]), "A compl\u00e9ter"});
        return result;
    }

    @Generated
    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    @Generated
    public List<GroupeCibleDTO> getGroupesCibles() {
        return this.groupesCibles;
    }
}

