/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.i18n.I18n;

public class EffectiveCropCycleDuplicate
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 1L;
    protected String fromZoneId;
    protected String toZoneId;
    protected EffectiveCropCycleService effectiveCropCycleService;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setFromZoneId(String fromZoneId) {
        this.fromZoneId = fromZoneId;
    }

    public void setToZoneId(String toZoneId) {
        this.toZoneId = toZoneId;
    }

    public String getToZoneId() {
        return this.toZoneId;
    }

    @Action(results={@Result(name={"success"}, type="redirectAction", params={"actionName", "effective-crop-cycles-edit-input", "zoneTopiaId", "${toZoneId}"}), @Result(name={"error"}, type="redirectAction", params={"actionName", "effective-crop-cycles-list"})})
    public String execute() {
        if (Strings.isNullOrEmpty((String)this.fromZoneId) || Strings.isNullOrEmpty((String)this.toZoneId)) {
            this.notificationSupport.effectiveCropCycleNotDuplicable();
            return "error";
        }
        Set excludedInputs = this.effectiveCropCycleService.duplicateEffectiveCropCycles(this.fromZoneId, this.toZoneId, true);
        this.notificationSupport.effectiveCropCycleDuplicate();
        if (!excludedInputs.isEmpty()) {
            String names = excludedInputs.stream().map(input -> String.format("'%s'", input.getInputName())).collect(Collectors.joining(", "));
            if (excludedInputs.size() > 1) {
                this.notificationSupport.warning(String.format(I18n.t((String)"warning.duplication.inputsExcluded", (Object[])new Object[0]), names), new Object[0]);
            } else {
                this.notificationSupport.warning(String.format(I18n.t((String)"warning.duplication.inputExcluded", (Object[])new Object[0]), names), new Object[0]);
            }
        }
        return "success";
    }
}

