/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AttachmentsDownload
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 1864154104471757665L;
    private static final Log LOGGER = LogFactory.getLog(AttachmentsDownload.class);
    protected String attachmentTopiaId;
    protected AttachmentMetadata attachmentMetadata;

    public void setAttachmentTopiaId(String attachmentTopiaId) {
        this.attachmentTopiaId = attachmentTopiaId;
    }

    public AttachmentMetadata getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    @Action(results={@Result(type="stream", params={"contentType", "${attachmentMetadata.contentType}", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${attachmentMetadata.name}\""})})
    public String execute() throws Exception {
        this.attachmentMetadata = this.attachmentService.getAttachmentMetadata(this.attachmentTopiaId);
        return "success";
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = this.attachmentService.getAttachmentContent(this.attachmentTopiaId);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Can't download file", (Throwable)ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", (Throwable)ex);
        }
        return inputStream;
    }
}

