/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.converters.LocalDateTimeHelper;
import java.time.LocalDateTime;
import java.time.Month;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class Login
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 3750812084600471474L;
    private static final Log LOGGER = LogFactory.getLog(Login.class);
    private static final LocalDateTime DEFAULT_BROADCAST_DATE = LocalDateTime.of(2014, Month.JANUARY, 1, 0, 0);
    protected transient UserService userService;
    protected String email;
    protected String password;
    protected String next;
    protected String actionMessage;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setActionMessage(String actionMessage) {
        this.actionMessage = actionMessage;
    }

    @Action(value="login-input")
    public String input() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.actionMessage)) {
            this.addActionMessage(this.actionMessage);
        }
        if (this.authorizationService.isInMaintenanceMode()) {
            this.addActionError(this.authorizationService.getMaintenanceModeMessage());
        }
        return super.input();
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.email)) {
            this.addFieldError("email", "Le champ 'email' est obligatoire");
        }
        if (Strings.isNullOrEmpty((String)this.password)) {
            this.addFieldError("password", "Le champ 'password' est obligatoire");
        }
    }

    public String execute() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("[sid=%s] Trying to login with email '%s'", this.getSessionId(), this.email));
        }
        String errorMessage = null;
        AuthenticatedUser loginResult = this.authenticationService.login(this.email, this.password);
        if (loginResult != null) {
            if (this.authorizationService.isInMaintenanceMode() && !this.authorizationService.isAdminFromUserId(loginResult.getTopiaId())) {
                errorMessage = this.authorizationService.getMaintenanceModeMessage();
                loginResult = null;
            }
        } else {
            errorMessage = this.userService.isValidEmail(this.email) && !this.userService.isUserActive(this.email) ? "Votre compte est d\u00e9sactiv\u00e9, merci de contacter un administrateur d'Agrosyst." : "\u00c9chec de connexion.";
        }
        if (errorMessage != null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("[sid=%s] Trying to login with email '%s' error message %s", this.getSessionId(), this.email, errorMessage));
            }
            this.addActionError(errorMessage);
            return "input";
        }
        Preconditions.checkState((loginResult != null ? 1 : 0) != 0);
        if (Strings.isNullOrEmpty((String)this.next) || this.next.contains("/auth/login.action") || this.next.contains("/auth/login-input.action")) {
            this.next = this.initNext();
        }
        if (this.next.contains(";jsessionid=")) {
            this.next = this.next.substring(0, this.next.indexOf(";jsessionid="));
        }
        LocalDateTime lastBroadcastDate = this.userService.getLastMessageReadDate(loginResult.getTopiaId()).orElse(DEFAULT_BROADCAST_DATE);
        this.next = this.next.contains("?") ? this.next + "&" : this.next + "?";
        this.next = this.next + "lastBroadcastDate=" + LocalDateTimeHelper.urlSafeFormat((LocalDateTime)lastBroadcastDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("[sid=%s] user email '%s' redirect to %s", loginResult.getSid(), this.email, this.next));
        }
        this.applicationContext.writeAuthenticationCookie(loginResult, this.getCookieHelper());
        this.servletResponse.sendRedirect(this.next);
        return null;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNext() {
        return this.next;
    }

    protected String initNext() {
        return this.servletRequest.getContextPath() + "/";
    }
}

