/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

public class Home
extends AbstractAdminAction {
    private static final long serialVersionUID = 6516792714690014172L;
    protected transient DomainService domainService;
    protected transient GrowingSystemService growingSystemService;
    protected transient GrowingPlanService growingPlanService;
    protected transient NetworkService networkService;
    protected transient UserService userService;
    protected boolean admin;
    protected long domainsCount;
    protected long activeDomainsCount;
    protected long growingSystemsCount;
    protected long activeGrowingSystemsCount;
    protected long growingPlansCount;
    protected long activeGrowingPlansCount;
    protected long networksCount;
    protected long activeNetworksCount;
    protected long usersCount;
    protected long activeUsersCount;
    protected int connectedUsersCount;
    protected int activeSessionsCount;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String execute() throws Exception {
        this.admin = this.authorizationService.isAdmin();
        boolean isDp = this.authorizationService.isIsDataProcessor();
        if (!this.admin && !isDp) {
            throw new AgrosystAccessDeniedException();
        }
        this.domainsCount = this.domainService.getDomainsCount(null);
        this.activeDomainsCount = this.domainService.getDomainsCount(Boolean.valueOf(true));
        this.growingSystemsCount = this.growingSystemService.getGrowingSystemsCount(null);
        this.activeGrowingSystemsCount = this.growingSystemService.getGrowingSystemsCount(Boolean.valueOf(true));
        this.growingPlansCount = this.growingPlanService.getGrowingPlansCount(null);
        this.activeGrowingPlansCount = this.growingPlanService.getGrowingPlansCount(Boolean.valueOf(true));
        this.networksCount = this.networkService.getNetworksCount(null);
        this.activeNetworksCount = this.networkService.getNetworksCount(Boolean.valueOf(true));
        this.usersCount = this.userService.getUsersCount(null);
        this.activeUsersCount = this.userService.getUsersCount(Boolean.valueOf(true));
        AbstractAgrosystAction.ActiveSessionsAndUsers activeSessionsAndUsers = this.computeConnectedUsersCount();
        this.activeSessionsCount = activeSessionsAndUsers.sessionsCount();
        this.connectedUsersCount = activeSessionsAndUsers.uniqueUsersCount();
        return "success";
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Long getDomainsCount() {
        return this.domainsCount;
    }

    public Long getGrowingSystemsCount() {
        return this.growingSystemsCount;
    }

    public Long getGrowingPlansCount() {
        return this.growingPlansCount;
    }

    public Long getNetworksCount() {
        return this.networksCount;
    }

    public Long getUsersCount() {
        return this.usersCount;
    }

    public Long getActiveUsersCount() {
        return this.activeUsersCount;
    }

    public Long getActiveNetworksCount() {
        return this.activeNetworksCount;
    }

    public Long getActiveGrowingPlansCount() {
        return this.activeGrowingPlansCount;
    }

    public Long getActiveGrowingSystemsCount() {
        return this.activeGrowingSystemsCount;
    }

    public Long getActiveDomainsCount() {
        return this.activeDomainsCount;
    }

    public int getConnectedUsersCount() {
        return this.connectedUsersCount;
    }

    public int getActiveSessionsCount() {
        return this.activeSessionsCount;
    }
}

