/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.report.ReportGrowingSystem;
import fr.inra.agrosyst.api.entities.report.ReportRegional;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.web.AgrosystWebNotification;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;

public class AgrosystWebNotificationSupport
implements Serializable {
    private static final long serialVersionUID = -4427471517335097967L;
    protected final LinkedHashSet<AgrosystWebNotification> infoNotifications = new LinkedHashSet();
    protected final LinkedHashSet<AgrosystWebNotification> warningNotifications = new LinkedHashSet();
    protected final LinkedHashSet<AgrosystWebNotification> errorNotifications = new LinkedHashSet();
    protected final LinkedHashSet<AgrosystWebNotification> lightBoxNotifications = new LinkedHashSet();
    protected Language language;

    public String toString() {
        return "AgrosystWebNotificationSupport{infoNotifications=" + String.valueOf(this.infoNotifications) + ", warningNotifications=" + String.valueOf(this.warningNotifications) + ", errorNotifications=" + String.valueOf(this.errorNotifications) + ", lightBoxNotifications=" + String.valueOf(this.lightBoxNotifications) + "}";
    }

    public boolean isEmpty() {
        boolean result = this.infoNotifications.isEmpty() && this.warningNotifications.isEmpty() && this.errorNotifications.isEmpty() && this.lightBoxNotifications.isEmpty();
        return result;
    }

    protected void addInfoNotification(AgrosystWebNotification msg) {
        this.infoNotifications.add(msg);
    }

    protected void addWarningNotification(AgrosystWebNotification msg) {
        this.warningNotifications.add(msg);
    }

    protected void addErrorNotification(AgrosystWebNotification msg) {
        this.errorNotifications.add(msg);
    }

    protected void addLightBoxNotification(AgrosystWebNotification msg) {
        this.lightBoxNotifications.add(msg);
    }

    public String getTranslatedText(String messageKey, Object ... args) {
        Locale locale = Optional.ofNullable(this.language).map(Language::getLocale).orElse(Locale.FRENCH);
        String translatedText = I18n.l((Locale)locale, (String)messageKey, (Object[])args);
        return translatedText;
    }

    public void info(String message, Object ... args) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])args);
        this.addInfoNotification(msg);
    }

    public void error(String message, Object ... args) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])args);
        this.addErrorNotification(msg);
    }

    public void warning(String message, Object ... args) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])args);
        this.addWarningNotification(msg);
    }

    public void domainSaved(Domain domain) {
        String text = this.getTranslatedText("domain.save.confirmation", new Object[]{domain.getName()});
        this.addInfoNotification(new AgrosystWebNotification(text));
    }

    public void domainExtendError(String message) {
        this.error(message, new Object[0]);
    }

    public void domainExtendWarning(String message) {
        this.warning(message, new Object[0]);
    }

    public void domainDeletionError(String message) {
        this.error(message, new Object[0]);
    }

    public void domainDeleted(String domainNameAndCampagne) {
        String text = this.getTranslatedText("domain.deleted", new Object[]{domainNameAndCampagne});
        this.addInfoNotification(new AgrosystWebNotification(text));
    }

    public void importSuccess() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Import termin\u00e9.", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void importError(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Erreur d'import du fichier : %s", (Object[])new Object[]{message});
        this.addErrorNotification(msg);
    }

    public void growingPlanSaved(GrowingPlan growingPlan) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Dispositif '%s' enregistr\u00e9", (Object[])new Object[]{growingPlan.getName()});
        this.addInfoNotification(msg);
    }

    public void growingSystemSaved(GrowingSystem growingSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Syst\u00e8me de culture '%s' enregistr\u00e9", (Object[])new Object[]{growingSystem.getName()});
        this.addInfoNotification(msg);
    }

    public void importSuccess(String message, long duration, int created, int updated, int deleted, int ignored) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[]{duration, created, updated, deleted, ignored});
        this.addInfoNotification(msg);
    }

    public void practicedSystemSaved(PracticedSystem practicedSystem) {
        String text = this.getTranslatedText("practicedSystem.save.confirmation", new Object[]{practicedSystem.getName()});
        this.addInfoNotification(new AgrosystWebNotification(text));
    }

    public void networkSaved(Network network) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"R\u00e9seau '%s' enregistr\u00e9", (Object[])new Object[]{network.getName()});
        this.addInfoNotification(msg);
    }

    public void plotSaved(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Parcelle '%s' enregistr\u00e9e", (Object[])new Object[]{plot.getName()});
        this.addInfoNotification(msg);
    }

    public void plotActivatedStatus(List<String> plots, boolean activate) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d parcelle%s %s", (Object[])new Object[]{plots.size(), plots.isEmpty() || plots.size() == 1 ? "" : "s", activate ? "activ\u00e9e" : "d\u00e9sactiv\u00e9es"});
        this.addInfoNotification(msg);
    }

    public void plotActivatedStatus(Integer nbUpdated, boolean activate) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d parcelle%s %s", (Object[])new Object[]{nbUpdated, nbUpdated == 0 || nbUpdated == 1 ? "" : "s", activate ? "activ\u00e9e" : "d\u00e9sactiv\u00e9es"});
        this.addInfoNotification(msg);
    }

    public void zoneActivatedStatus(Integer nbUpdated, boolean activate) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d zone%s %s", (Object[])new Object[]{nbUpdated, nbUpdated == 0 || nbUpdated == 1 ? "" : "s", activate ? "activ\u00e9e" : "d\u00e9sactiv\u00e9es"});
        this.addInfoNotification(msg);
    }

    public void plotMerged(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Parcelles fusionn\u00e9es en '%s'", (Object[])new Object[]{plot.getName()});
        this.addInfoNotification(msg);
    }

    public void practicedPlotSaved(PracticedPlot practicedPlot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Parcelle type '%s' enregistr\u00e9e", (Object[])new Object[]{practicedPlot.getName()});
        this.addInfoNotification(msg);
    }

    public void userSaved(UserDto user) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Utilisateur '%s %s' enregistr\u00e9", (Object[])new Object[]{user.getLastName(), user.getFirstName()});
        this.addInfoNotification(msg);
    }

    public void authenticatedUserSaved(UserDto user) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Profil enregistr\u00e9", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void decisionRuleSaved(DecisionRule decisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"R\u00e8gle de d\u00e9cision '%s' enregistr\u00e9e", (Object[])new Object[]{decisionRule.getName()});
        this.addInfoNotification(msg);
    }

    public void decisionRuleDuplicated(DecisionRule decisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"R\u00e8gle de d\u00e9cision '%s' dupliqu\u00e9e", (Object[])new Object[]{decisionRule.getName()});
        this.addInfoNotification(msg);
    }

    public void managementModeDuplicated() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Mod\u00e8le d\u00e9cisionnel dupliqu\u00e9", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void managementModeDeleted(int nbRemoved) {
        String plural = nbRemoved > 1 ? "s" : "";
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)String.format("%d mod\u00e8le%s d\u00e9cisionnel%s supprim\u00e9%s", nbRemoved, plural, plural, plural), (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void newDecisionRuleCreated(DecisionRule newDecisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Version %d de la r\u00e8gle de d\u00e9cision '%s' cr\u00e9\u00e9e", (Object[])new Object[]{newDecisionRule.getVersionNumber(), newDecisionRule.getName()});
        this.addInfoNotification(msg);
    }

    public void newManagementModeCreated(ManagementMode managementMode) {
        String txtMsg = managementMode.getCategory() == ManagementModeCategory.PLANNED ? "Mod\u00e8le d\u00e9cisionnel pr\u00e9vu cr\u00e9\u00e9" : "Mod\u00e8le d\u00e9cisionnel constat\u00e9 cr\u00e9\u00e9";
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)txtMsg, (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void managementModeSaved(ManagementMode managementMode) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Mod\u00e8le d\u00e9cisionnel enregistr\u00e9", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void culturalInterventionCreated() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Interventions culturales enregistr\u00e9es", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void performanceSaved(Performance performance) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Performance enregistr\u00e9e. Le fichier est en cours de g\u00e9n\u00e9ration...", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    protected void notWritable(String entityType, String pronom) {
        String message = String.format("Vous n'avez pas les droits n\u00e9cessaires pour modifier %s %s", pronom, entityType);
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addWarningNotification(msg);
    }

    public void defaultMaterialUsed() {
        String message = "Vous avez du mat\u00e9riel par d\u00e9faut import\u00e9 depuis eDaplos, merci de compl\u00e9ter ce mat\u00e9riel.";
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addWarningNotification(msg);
    }

    public void unauthorizedSeedPlantUnit() {
        String message = "Au moins un des lots de semence est d\u00e9clar\u00e9 avec une unit\u00e9 d\u2019application qui n\u2019est pas autoris\u00e9e pour une des cultures.";
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addWarningNotification(msg);
    }

    protected void notWritable(String entityType) {
        this.notWritable(entityType, "ce");
    }

    public void domainNotWritable() {
        this.notWritable("domaine");
    }

    public void growingPlanNotWritable() {
        this.notWritable("dispositif");
    }

    public void growingSystemNotWritable() {
        this.notWritable("syst\u00e8me de culture");
    }

    public void networkNotWritable() {
        this.notWritable("r\u00e9seau");
    }

    public void practicedSystemNotWritable() {
        this.notWritable("syst\u00e8me synth\u00e9tis\u00e9");
    }

    public void managementModeNotWritable() {
        this.notWritable("mod\u00e8le d\u00e9cisionnel");
    }

    public void decisionRuleNotWritable() {
        this.notWritable("r\u00e8gle de d\u00e9cision", "cette");
    }

    public void effectiveCropCyclesNotWritable() {
        this.notWritable("cycles r\u00e9alis\u00e9s", "ces");
    }

    public void performanceNotWritable() {
        this.notWritable("performance", "cette");
    }

    public void plotNotWritable() {
        this.notWritable("parcelle", "cette");
    }

    public void practicedPlotNotWritable() {
        this.notWritable("parcelle type", "cette");
    }

    public void domainValidated(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Domaine '%s' valid\u00e9 pour la campagne '%d-%d'", (Object[])new Object[]{domain.getName(), domain.getCampaign() - 1, domain.getCampaign()});
        this.addInfoNotification(msg);
    }

    public void growingSystemValidated(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void growingSystemValidatedError(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addErrorNotification(msg);
    }

    public void practicedSystemValidated(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void practicedSystemValidatedError(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)message, (Object[])new Object[0]);
        this.addErrorNotification(msg);
    }

    public void growingPlanValidated(GrowingPlan growingPlan) {
        int campaign = growingPlan.getDomain().getCampaign();
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Dispositif '%s' valid\u00e9 pour la campagne '%d-%d'", (Object[])new Object[]{growingPlan.getName(), campaign - 1, campaign});
        this.addInfoNotification(msg);
    }

    public void userImported(ImportResult result) {
        if (result.hasErrors()) {
            for (String error : result.getErrors()) {
                AgrosystWebNotification msg = AgrosystWebNotification.of((String)error, (Object[])new Object[0]);
                this.addInfoNotification(msg);
            }
        } else {
            AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d utilisateurs cr\u00e9\u00e9s. %d email envoy\u00e9s. %d lignes ignor\u00e9es.", (Object[])new Object[]{result.getCreated(), result.getCreated(), result.getIgnored()});
            this.addInfoNotification(msg);
        }
    }

    public void userRolesUpdated(ImportResult result) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"R\u00f4les de %d utilisateurs mis \u00e0 jour (%d lignes ignor\u00e9es).", (Object[])new Object[]{result.getCreated(), result.getIgnored()});
        this.addInfoNotification(msg);
    }

    public void networkImported(ImportResult result) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d r\u00e9seaux mis \u00e0 jour, %d r\u00e9seaux cr\u00e9\u00e9(s), erreur(s) : %s", (Object[])new Object[]{result.getUpdated(), result.getCreated(), result.getErrors()});
        this.addInfoNotification(msg);
    }

    public void plotNotMergeable() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Les parcelles ne peuvent \u00eatre fusionn\u00e9es!", (Object[])new Object[0]);
        this.addWarningNotification(msg);
    }

    public void practicedSystemDuplicate() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Syst\u00e8me synth\u00e9tis\u00e9 dupliqu\u00e9.", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void practicedSystemNotDuplicable(String practicedSystemId, String growingSystemId) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Le syst\u00e8me synth\u00e9tis\u00e9 n'a pu \u00eatre dupliqu\u00e9 ! Duplication depuis le syst\u00e8me synth\u00e9tis\u00e9 avec comme identifiant :&nbsp;%s sur le syst\u00e8me de culture avec comme identifiant &nbsp;:%s", (Object[])new Object[]{practicedSystemId, growingSystemId});
        this.addWarningNotification(msg);
    }

    public void practicedSystemNotDuplicable(String error) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"La duplication du syst\u00e8me synth\u00e9tis\u00e9 \u00e0 rencontr\u00e9 un probl\u00e8me: %s", (Object[])new Object[]{error});
        this.addWarningNotification(msg);
    }

    public void effectiveCropCycleDuplicate() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Cycles de cultures dupliqu\u00e9s.", (Object[])new Object[0]);
        this.addInfoNotification(msg);
    }

    public void effectiveCropCycleNotDuplicable() {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Les cycles de cultures n'ont pu \u00eatre dupliqu\u00e9s!", (Object[])new Object[0]);
        this.addWarningNotification(msg);
    }

    public void usersImportFailed(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Echec de l'import du fichier des utilisateurs! %s", (Object[])new Object[]{message});
        this.addErrorNotification(msg);
    }

    public void rulesImportFailed(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Echec de l'import du fichier des r\u00f4les! %s", (Object[])new Object[]{message});
        this.addErrorNotification(msg);
    }

    public void usersAndRolesImportFailed(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Echec d'import des utilisateurs et r\u00f4les : %s", (Object[])new Object[]{message});
        this.addErrorNotification(msg);
    }

    public void eDaplosDataImported(Map<Class, ImportResult> importResult) {
        if (importResult != null && !importResult.isEmpty()) {
            ImportResult result = importResult.get(Domain.class);
            AgrosystWebNotification msg = AgrosystWebNotification.of((String)"%d domain(s) mis \u00e0 jour, %d domain(s) cr\u00e9\u00e9(s)", (Object[])new Object[]{result.getUpdated(), result.getCreated()});
            this.addInfoNotification(msg);
            result = importResult.get(Plot.class);
            msg = AgrosystWebNotification.of((String)"%d parcelle(s) mise(s) \u00e0 jour, %d parcelle(s) cr\u00e9\u00e9e(s)", (Object[])new Object[]{result.getUpdated(), result.getCreated()});
            this.addInfoNotification(msg);
        }
    }

    public void reportRegionalSaved(ReportRegional reportRegional) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Bilan de campagne / \u00e9chelle regionale '%s' enregistr\u00e9", (Object[])new Object[]{reportRegional.getName()});
        this.addInfoNotification(msg);
    }

    public void reportRegionalNotWritable() {
        this.notWritable("bilan de campagne / \u00e9chelle r\u00e9gional");
    }

    public void reportGrowingSystemSaved(ReportGrowingSystem reportGrowingSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of((String)"Bilan de campagne / \u00e9chelle syst\u00e8me de culture '%s' enregistr\u00e9", (Object[])new Object[]{reportGrowingSystem.getName()});
        this.addInfoNotification(msg);
    }

    public void reportGrowingSystemNotWritable() {
        this.notWritable("bilan de campagne / \u00e9chelle syst\u00e8me de culture");
    }

    public void failedDeleteRegionalReports(List<String> reportRegionalIds, List<String> reportGrowingSystemeNames) {
        this.lightBoxNotifications.clear();
        if (CollectionUtils.isNotEmpty(reportGrowingSystemeNames)) {
            String body;
            String part0;
            String string = part0 = reportRegionalIds.size() == 1 ? "La suppression du bilan de campagne \u00e9chelle r\u00e9gionale est impossible car il est toujours utilis\u00e9 " : "La suppression des bilans de campagnes \u00e9chelle r\u00e9gionale est impossible car ils sont toujours utilis\u00e9s ";
            if (reportGrowingSystemeNames.size() == 1) {
                body = "par le bilan de campagne \u00e9chelle syst\u00e8me de culture suivant&nbsp:<ul><li><b>'" + reportGrowingSystemeNames.get(0) + "'</b></li></ul>";
            } else {
                StringBuilder names = new StringBuilder("<ul>");
                for (String reportGrowingSystameName : reportGrowingSystemeNames) {
                    names.append("<li><b>").append(reportGrowingSystameName).append("</b></li>");
                }
                names.append("</ul>");
                body = "par les bilans de campagne \u00e9chelle syst\u00e8me de culture suivants&nbsp:" + String.valueOf(names);
            }
            String deleteReportsMessage = part0 + body;
            AgrosystWebNotification msg = AgrosystWebNotification.of((String)deleteReportsMessage, (Object[])new Object[0]);
            this.addLightBoxNotification(msg);
        }
    }

    public Set<AgrosystWebNotification> consumeInfoNotifications() {
        LinkedHashSet<AgrosystWebNotification> result = new LinkedHashSet<AgrosystWebNotification>(this.infoNotifications);
        this.infoNotifications.clear();
        return result;
    }

    public Set<AgrosystWebNotification> consumeWarningNotifications() {
        LinkedHashSet<AgrosystWebNotification> result = new LinkedHashSet<AgrosystWebNotification>(this.warningNotifications);
        this.warningNotifications.clear();
        return result;
    }

    public Set<AgrosystWebNotification> consumeErrorNotifications() {
        LinkedHashSet<AgrosystWebNotification> result = new LinkedHashSet<AgrosystWebNotification>(this.errorNotifications);
        this.errorNotifications.clear();
        return result;
    }

    public Set<AgrosystWebNotification> consumeLightBoxNotifications() {
        LinkedHashSet<AgrosystWebNotification> result = new LinkedHashSet<AgrosystWebNotification>(this.lightBoxNotifications);
        this.lightBoxNotifications.clear();
        return result;
    }

    public boolean isInfoNotificationsEmpty() {
        boolean result = this.infoNotifications.isEmpty();
        return result;
    }

    public boolean isErrorNotificationsEmpty() {
        boolean result = this.errorNotifications.isEmpty();
        return result;
    }

    public boolean isWarningNotificationsEmpty() {
        boolean result = this.warningNotifications.isEmpty();
        return result;
    }

    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }
}

