/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebNotificationSupport;
import fr.inra.agrosyst.web.AgrosystWebNotificationSupportDistributed;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import fr.inra.agrosyst.web.actions.domains.DomainsPreImportEdaplos;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Parameter;
import org.nuiton.util.beans.BeanUtil;

public class AgrosystWebInterceptor
implements Interceptor {
    private static final long serialVersionUID = 2035088485913506328L;
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebInterceptor.class);
    public static final String LANGUAGE_PARAMETER = "lang";

    public void init() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Initializing Agrosyst Web Interceptor");
        }
    }

    protected Optional<AuthenticatedUser> getAuthenticatedUser(ActionInvocation invocation) {
        ActionContext invocationContext = invocation.getInvocationContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)invocationContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        AuthenticatedUser userDto = (AuthenticatedUser)httpServletRequest.getAttribute("authenticatedUser");
        Optional<AuthenticatedUser> result = Optional.ofNullable(userDto);
        return result;
    }

    protected AgrosystWebNotificationSupport getNotificationSupport(AgrosystWebApplicationContext webApplicationContext, Optional<AuthenticatedUser> authenticatedUser) {
        if (authenticatedUser.isPresent()) {
            Map cache = webApplicationContext.getDistributedCache("notifications");
            String userId = authenticatedUser.get().getTopiaId();
            AgrosystWebNotificationSupportDistributed notificationSupport = Optional.ofNullable((AgrosystWebNotificationSupportDistributed)cache.get(userId)).orElseGet(AgrosystWebNotificationSupportDistributed::new);
            notificationSupport.setLanguage(authenticatedUser.get().getLanguage());
            Runnable updater = () -> {
                if (notificationSupport.isEmpty()) {
                    cache.remove(userId);
                } else {
                    cache.put(userId, notificationSupport);
                }
            };
            notificationSupport.setUpdater(updater);
            return notificationSupport;
        }
        AgrosystWebNotificationSupport result = new AgrosystWebNotificationSupport();
        result.setLanguage(Language.FRENCH);
        return result;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof AbstractAgrosystAction) {
            AgrosystWebApplicationContext webApplicationContext = this.getAgrosystApplicationContext(invocation);
            Optional authenticatedUser = this.getAuthenticatedUser(invocation);
            ServiceContext serviceContext = this.newServiceContext(webApplicationContext, authenticatedUser);
            Parameter lang = invocation.getInvocationContext().getParameters().get((Object)LANGUAGE_PARAMETER);
            if (lang.isDefined()) {
                invocation.getInvocationContext().withLocale(Language.fromTrigram((String)lang.getValue()).getLocale());
            } else {
                authenticatedUser.ifPresent(user -> invocation.getInvocationContext().withLocale(user.getLocale()));
            }
            try {
                Object propertyDescriptor2;
                Set descriptors = BeanUtil.getDescriptors(action.getClass(), (Predicate)BeanUtil.IS_WRITE_DESCRIPTOR);
                for (Object propertyDescriptor2 : descriptors) {
                    Class<?> propertyType = ((PropertyDescriptor)propertyDescriptor2).getPropertyType();
                    AgrosystService toInject = null;
                    if (AgrosystService.class.isAssignableFrom(propertyType)) {
                        Class<?> clazz = propertyType;
                        toInject = serviceContext.newService(clazz);
                    } else if (AgrosystWebConfig.class.isAssignableFrom(propertyType)) {
                        toInject = webApplicationContext.getWebConfig();
                    } else if (AgrosystWebApplicationContext.class.isAssignableFrom(propertyType)) {
                        toInject = webApplicationContext;
                    } else if (AgrosystWebNotificationSupport.class.isAssignableFrom(propertyType)) {
                        AgrosystWebNotificationSupport notificationSupport = this.getNotificationSupport(webApplicationContext, authenticatedUser);
                        toInject = notificationSupport;
                    }
                    if (toInject == null) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("injecting " + String.valueOf(toInject) + " in action " + String.valueOf(action)));
                    }
                    ((PropertyDescriptor)propertyDescriptor2).getWriteMethod().invoke(action, toInject);
                }
                String result = invocation.invoke();
                this.checkForLayoutData((AbstractAgrosystAction)action);
                propertyDescriptor2 = result;
                return propertyDescriptor2;
            }
            catch (Exception eee) {
                this.rollbackTransaction(serviceContext);
                String userEmail = authenticatedUser.map(AuthenticatedUser::getEmail).orElse("?");
                if (LOGGER.isErrorEnabled()) {
                    String message = String.format("Exception occurred for user '%s' during Agrosyst action invocation (action is '%s'): %s", userEmail, action.getClass().getName(), eee.getMessage());
                    LOGGER.error((Object)message, (Throwable)eee);
                }
                throw eee;
            }
            finally {
                this.checkClosedPersistenceContext(serviceContext);
            }
        }
        return invocation.invoke();
    }

    protected void checkForLayoutData(AbstractAgrosystAction action) {
        if (!(action instanceof AbstractJsonAction) && (action.hasErrors() || "GET".equals(ServletActionContext.getRequest().getMethod()) || action instanceof DomainsPreImportEdaplos)) {
            action.initLayoutData();
        }
    }

    protected AgrosystWebApplicationContext getAgrosystApplicationContext(ActionInvocation invocation) {
        AgrosystWebApplicationContext applicationContext = (AgrosystWebApplicationContext)invocation.getInvocationContext().getApplication().get(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((applicationContext != null ? 1 : 0) != 0, (Object)AgrosystWebApplicationContext.MISSING_APPLICATION_CONTEXT);
        return applicationContext;
    }

    protected ServiceContext newServiceContext(AgrosystWebApplicationContext webApplicationContext, Optional<AuthenticatedUser> authenticatedUser) {
        ServiceContext result;
        block2: {
            result = null;
            AgrosystTopiaApplicationContext topiaApplicationContext = webApplicationContext.getApplicationContext();
            Preconditions.checkState((topiaApplicationContext != null ? 1 : 0) != 0);
            try {
                result = authenticatedUser.isPresent() ? topiaApplicationContext.newServiceContext(authenticatedUser.get()) : topiaApplicationContext.newServiceContext();
            }
            catch (Exception eee) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)"Unable to create local serviceContext", (Throwable)eee);
            }
        }
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"ServiceContext not instantiated, check configuration");
        return result;
    }

    protected void checkClosedPersistenceContext(ServiceContext serviceContext) {
        try {
            serviceContext.close();
        }
        catch (Exception eee) {
            if (LOGGER.isFatalEnabled()) {
                LOGGER.fatal((Object)"Unable to close persistence context !", (Throwable)eee);
            }
            throw new AgrosystTechnicalException("Unable to close persistence context !", (Throwable)eee);
        }
    }

    protected void rollbackTransaction(ServiceContext serviceContext) {
        try {
            AgrosystTopiaPersistenceContext persistenceContext = serviceContext.getPersistenceContext(false);
            if (persistenceContext != null) {
                persistenceContext.rollback();
            }
        }
        catch (Exception eee) {
            if (LOGGER.isFatalEnabled()) {
                LOGGER.fatal((Object)"Unable to rollback persistence context !", (Throwable)eee);
            }
            throw new AgrosystTechnicalException("Unable to rollback persistence context !", (Throwable)eee);
        }
    }

    public void destroy() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Destroy Interceptor");
        }
    }
}

