package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersListJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class UsersListJson extends AbstractJsonAction {

    private static final long serialVersionUID = 8714662434791990669L;

    protected transient UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected String filter;

    protected ResultList<UserDto> users;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        UserFilter usersFilter = getGson().fromJson(this.filter, UserFilter.class);

        users = userService.getFilteredUsers(usersFilter, true);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return users;
    }

}
