package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefMinUnifaJson.java 3024 2014-01-31 13:35:17Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefMinUnifaJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * 
 * @author cosse
 */
public class LoadRefMinUnifaJson extends AbstractJsonAction {

    private static final long serialVersionUID = -2051822874070203733L;

    protected transient ReferentialService referentialService;
    protected transient PracticedSystemService practicedSystemService;

    protected Integer categ;

    protected String fertilizerShape;

    protected List<RefFertiMinUNIFA> refFertiMinUnifas;

    protected String productId;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    @Override
    public String execute() throws Exception {
        refFertiMinUnifas = referentialService.findAllActiveRefFertiMinUnifaByCategAndShape(categ, fertilizerShape, productId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return refFertiMinUnifas;
    }

    public void setCateg(Integer categ) {
        this.categ = categ;
    }

    public void setFertilizerShape(String fertilizerShape) {
        this.fertilizerShape = fertilizerShape;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }
}
