package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefInterventionAgrosystTravailEdisJson.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefInterventionAgrosystTravailEdisJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Chargement des {@link RefInterventionAgrosystTravailEDI} au moment où on choisit le type d'action.
 * 
 * @author Eric Chatellier
 */
public class LoadRefInterventionAgrosystTravailEdisJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5842359927618631165L;

    protected transient ReferentialService referentialService;

    protected AgrosystInterventionType agrosystInterventionType;

    protected List<RefInterventionAgrosystTravailEDI> interventionAgrosystTravailEDIs;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    public String execute() {
        interventionAgrosystTravailEDIs = referentialService.findAllActiveAgrosystActions(agrosystInterventionType);
        return SUCCESS;
    }
    @Override
    public Object getJsonData() {
        return interventionAgrosystTravailEDIs;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }
}
