package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaProductsJson.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaProductsJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadActaProductsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 3763987457979325440L;

    protected transient ReferentialService referentialService;

    protected List<RefActaTraitementsProduit> actaProducts;

    protected AgrosystInterventionType inputType;

    protected String productType;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public void setInputType(AgrosystInterventionType inputType) {
        this.inputType = inputType;
    }

    @Override
    public String execute() {
        actaProducts = referentialService.getActaTraitementsProduits(inputType, productType);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return actaProducts;
    }

}
