package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsEditJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.BioAgressorType;
import org.apache.struts2.convention.annotation.Action;

import com.google.common.base.Preconditions;

import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.measurement.ProtocoleVgObsFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * JSON action to retrieve a <code>list</code> of {@link RefMesure} according to a given filter.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class EffectiveMeasurementsEditJson extends AbstractJsonAction {

    private static final long serialVersionUID = -4576065541768079736L;

    protected transient MeasurementService measurementService;

    protected MeasurementType measurementType;

    protected VariableType variableType;

    protected String cropFamily;

    protected String vegetativeProfile;

    protected String vgObsFilter;

    protected BioAgressorType pestType;

    protected Object jsonData;

    public void setMeasurementObservationService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public void setMeasurementType(MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setCropFamily(String cropFamily) {
        this.cropFamily = cropFamily;
    }

    public void setVegetativeProfile(String vegetativeProfile) {
        this.vegetativeProfile = vegetativeProfile;
    }

    public void setPestType(BioAgressorType pestType) {
        this.pestType = pestType;
    }

    @Action("effective-measurements-variable-types-json")
    public String listVariableTypes() throws Exception {
        jsonData = measurementService.findAllVariableTypes(measurementType);
        return SUCCESS;
    }
    
    @Action("effective-measurements-variables-json")
    public String listVariables() throws Exception {
        jsonData = measurementService.findAllVariables(measurementType, variableType);
        return SUCCESS;
    }

    @Action("effective-measurements-stades-json")
    public String listStadeEdis() throws Exception {
        Preconditions.checkArgument(cropFamily != null ^ vegetativeProfile != null);
        jsonData = measurementService.findAllStadeEdi(cropFamily, vegetativeProfile);
        return SUCCESS;
    }

    public void setVgObsFilter(String vgObsFilter) {
        this.vgObsFilter = vgObsFilter;
    }

    protected ProtocoleVgObsFilter getVgObsFilter() {
        ProtocoleVgObsFilter protocoleVgObsFilter = getGson().fromJson(vgObsFilter, ProtocoleVgObsFilter.class);
        return protocoleVgObsFilter;
    }

    @Action("effective-measurements-vgobs-labels-json")
    public String listVgobsLabels() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsLabels();
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-pests-json")
    public String listVgobsPests() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsPests(getVgObsFilter());
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-stades-json")
    public String listVgobsStades() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsStades(getVgObsFilter());
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-supports-json")
    public String listVgobsSupports() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsSupports(getVgObsFilter());
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-observations-json")
    public String listVgobsObservations() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsObservations(getVgObsFilter());
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-qualitatives-json")
    public String listVgobsQualitatives() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsQualitatives(getVgObsFilter());
        return SUCCESS;
    }

    @Action("effective-measurements-vgobs-units-json")
    public String listVgobsUnits() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsUnits(getVgObsFilter());
        return SUCCESS;
    }

    @Action("effective-measurements-vgobs-qualifiers-json")
    public String listVgobsQualifiers() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsQualifiers(getVgObsFilter());
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-pesttypes-json")
    public String listPestTypes() throws Exception {
        jsonData = measurementService.findAllEdiPestTypes();
        return SUCCESS;
    }

    @Action("effective-measurements-edi-pests-json")
    public String listPests() throws Exception {
        jsonData = measurementService.findAllEdiPests(pestType);
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-peststades-json")
    public String listPestStades() throws Exception {
        jsonData = measurementService.findAllEdiPestStades();
        return SUCCESS;
    }

    @Action("effective-measurements-edi-supports-json")
    public String listSupports() throws Exception {
        jsonData = measurementService.findAllSupportOrganeEDI();
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-notations-json")
    public String listNotations() throws Exception {
        jsonData = measurementService.findAllEdiNotations();
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-qualitatives-json")
    public String listQualitatives() throws Exception {
        jsonData = measurementService.findAllEdiQualitatives();
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-qualifierunits-json")
    public String listQualifierUnits() throws Exception {
        jsonData = measurementService.findAllEdiQualifiantUnits();
        return SUCCESS;
    }
    
    @Action("effective-measurements-edi-units-json")
    public String listUnits() throws Exception {
        jsonData = measurementService.findAllVgObsUnits();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
