package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCyclesListJson.java 4783 2015-02-11 16:36:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCyclesListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Display plots list that may be associated (or not) with crop cycles and cropping plan
 * intervention.
 * 
 * @author Eric Chatellier
 */
public class EffectiveCropCyclesListJson extends AbstractJsonAction {

    private static final long serialVersionUID = 7710481757962881593L;

    protected transient EffectiveCropCycleService effectiveCropCycleService;

    protected String filter;

    /** Liste des zones (point d'entrée des cycles réalisés). */
    protected ResultList<ZoneDto> zones;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() throws Exception {
        EffectiveZoneFilter plotFilter = getGson().fromJson(filter, EffectiveZoneFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        plotFilter.setNavigationContext(navigationContext);
        plotFilter.setPageSize(getConfig().getListResultsPerPage());
        plotFilter.setActive(true);
        // Get Cropping Plan Entries and Intervention nb
        zones = effectiveCropCycleService.getFilteredZonesAndCroppingPlanInfosDto(plotFilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return zones;
    }

}
