package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: WeatherStations.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/WeatherStations.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;

/**
 * Utility class for {@link WeatherStation} and {@link WeatherStationDto}.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class WeatherStations {

    /**
     * Creates a function that returns a {@link WeatherStationDto} instance from a given {@link WeatherStation}.
     *
     * @param defaultWeatherStationId if this {@link WeatherStation} is the default weather station selected (may be <code>null</code>)
     * @return the function that returns a {@link WeatherStationDto} instance from a given {@link WeatherStation}
     */
    protected static final Function<WeatherStation, WeatherStationDto> getFunctionWeatherStationToDto(final String defaultWeatherStationId) {
        Function<WeatherStation, WeatherStationDto> result = new Function<WeatherStation, WeatherStationDto>() {
            @Override
            public WeatherStationDto apply(WeatherStation input) {
                WeatherStationDto dto = new WeatherStationDto();
                String topiaId = input.getTopiaId();
                dto.setTopiaId(topiaId);
                dto.setRefStationMeteoTopiaId(input.getRefStationMeteo().getTopiaId());
                dto.setComment(input.getComment());
                dto.setData(input.getData());

                if (Strings.isNullOrEmpty(defaultWeatherStationId)) {
                    dto.setDefaultSelected(false);
                } else {
                    boolean defaultSelected = topiaId.equals(defaultWeatherStationId);
                    dto.setDefaultSelected(defaultSelected);
                }

                return dto;
            }

        };
        return result;
    }

    /**
     * Uses {@link WeatherStationDto} corresponding getter from each
     * {@link WeatherStation} instance setter.
     *
     * @param dto            {@link WeatherStationDto} DTO instance
     * @param weatherStation {@link WeatherStation} to update
     * @param refStationMeteo 
     */
    protected static final void dtoToWeatherStation(WeatherStationDto dto, WeatherStation weatherStation, RefStationMeteo refStationMeteo) {
        Preconditions.checkNotNull(dto);
        Preconditions.checkNotNull(weatherStation);
        Preconditions.checkNotNull(refStationMeteo);

        weatherStation.setRefStationMeteo(refStationMeteo);
        weatherStation.setComment(dto.getComment());
        weatherStation.setData(dto.getData());
    }
}
