package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GetRefLocationJson.java 4783 2015-02-11 16:36:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/GetRefLocationJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;

import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;


/**
 * Action d'afficher les information de localisation.
 * 
 * @author David Cossé
 */
public class GetRefLocationJson extends AbstractJsonAction {

    private static final long serialVersionUID = 1L;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected String locationTopiaId;

    protected String departement;
    protected String departementName;
    protected String petiteRegionAgricole;
    protected String petiteRegionAgricoleName;
    protected int region;

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    protected String orNC(String text) {
        String result = MoreObjects.firstNonNull(text, "n/c");
        return result;
    }

    @Override
    public String execute() throws Exception {

        RefLocation refLocation = referentialService.getRefLocation(locationTopiaId);

        departement = refLocation.getDepartement();
        String key = "departement." + Strings.padStart(departement, 2, '0');
        departementName = getText(key, "n/c");
        petiteRegionAgricole = orNC(refLocation.getPetiteRegionAgricoleCode());
        petiteRegionAgricoleName = orNC(refLocation.getPetiteRegionAgricoleNom());
        region = refLocation.getRegion();

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        Map<String, String> result = ImmutableMap.of(
                "departement", departement,
                "departementName", departementName,
                "petiteRegionAgricole", petiteRegionAgricole,
                "petiteRegionAgricoleName", petiteRegionAgricoleName,
                "region", String.valueOf(region)
        );
        return result;
    }

}
