package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Login.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/Login.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.web.AgrosystWebAuthenticationFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Login extends AbstractAgrosystAction {

    private static final long serialVersionUID = 3750812084600471474L;

    private static final Log log = LogFactory.getLog(Login.class);

    protected transient AuthenticationService authService;

    public void setAuthService(AuthenticationService authService) {
        this.authService = authService;
    }

    protected String email;
    protected String password;
    protected String next;

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNext(String next) {
        this.next = next;
    }

    @Override
    @Action("login-input")
    public String input() throws Exception {
        return super.input();
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(email)) {
            addFieldError("email", "Le champ 'email' est obligatoire");
        }
        if (Strings.isNullOrEmpty(password)) {
            addFieldError("password", "Le champ 'password' est obligatoire");
        }
    }

    @Override
    public String execute() throws Exception {
        if (log.isInfoEnabled()) {
            log.info(String.format("[%s] Trying to login with email '%s'", getSessionId(), email));
        }
        UserDto loginResult = authService.login(email, password);
        String token = null;
        if (loginResult != null) {
            token = loginResult.getAuthenticationToken();
            session.setBroadcastMessages(messageService.getMessagesFromDate(loginResult.getLastMessageReadDate()));
            session.setLastMessageDate(messageService.getLastMessageDate());
        }
        session.setAuthenticationToken(token); // even if authentication failed
        session.setAuthenticatedUser(loginResult);

        if (Strings.isNullOrEmpty(token)) {
            addActionError("Identifiants non valides");
            return INPUT;
        } else {
            if (Strings.isNullOrEmpty(next)
                    || next.contains(AgrosystWebAuthenticationFilter.AGROSYST_WEB_LOGIN_ACTION)
                    || next.contains(AgrosystWebAuthenticationFilter.AGROSYST_WEB_LOGIN_ACTION_INPUT)) {
                next = servletRequest.getContextPath();
            }
            if (next.contains(";jsessionid=")) {
                next = next.substring(0, next.indexOf(";jsessionid="));
            }
            servletResponse.sendRedirect(next);
            return null;
        }
    }

    public String getEmail() {
        return email;
    }

    public String getNext() {
        return next;
    }

}
