package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Home.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/Home.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Home extends AbstractAdminAction {

    private static final long serialVersionUID = 6516792714690014172L;

    protected transient DomainService domainService;

    protected transient GrowingSystemService growingSystemService;

    protected transient GrowingPlanService growingPlanService;

    protected transient NetworkService networkService;

    protected transient UserService userService;

    protected transient AuthenticationService authenticationService;

    protected boolean admin;

    protected long domainsCount;
    protected long activeDomainsCount;

    protected long growingSystemsCount;
    protected long activeGrowingSystemsCount;

    protected long growingPlansCount;
    protected long activeGrowingPlansCount;

    protected long networksCount;
    protected long activeNetworksCount;

    protected long usersCount;
    protected long activeUsersCount;
    protected long connectedUsersCount;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Override
    public String execute() throws Exception {
        admin = authorizationService.isAdmin();
        boolean isDp = authorizationService.isIsDataProcessor();
        if (!admin && !isDp) {
            throw new AgrosystAccessDeniedException();
        }

        domainsCount = domainService.getDomainsCount(null);
        activeDomainsCount = domainService.getDomainsCount(true);

        growingSystemsCount = growingSystemService.getGrowingSystemsCount(null);
        activeGrowingSystemsCount = growingSystemService.getGrowingSystemsCount(true);

        growingPlansCount = growingPlanService.getGrowingPlansCount(null);
        activeGrowingPlansCount = growingPlanService.getGrowingPlansCount(true);

        networksCount = networkService.getNetworksCount(null);
        activeNetworksCount = networkService.getNetworksCount(true);

        usersCount = userService.getUsersCount(null);
        activeUsersCount = userService.getUsersCount(true);
        connectedUsersCount = authenticationService.getConnectedUsersCount();

        return SUCCESS;
    }

    public boolean isAdmin() {
        return admin;
    }

    public Long getDomainsCount() {
        return domainsCount;
    }

    public Long getGrowingSystemsCount() {
        return growingSystemsCount;
    }

    public Long getGrowingPlansCount() {
        return growingPlansCount;
    }

    public Long getNetworksCount() {
        return networksCount;
    }

    public Long getUsersCount() {
        return usersCount;
    }

    public Long getActiveUsersCount() {
        return activeUsersCount;
    }

    public Long getActiveNetworksCount() {
        return activeNetworksCount;
    }

    public Long getActiveGrowingPlansCount() {
        return activeGrowingPlansCount;
    }

    public Long getActiveGrowingSystemsCount() {
        return activeGrowingSystemsCount;
    }

    public Long getActiveDomainsCount() {
        return activeDomainsCount;
    }

    public Long getConnectedUsersCount() {
        return connectedUsersCount;
    }
}
