package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebSession.java 4493 2014-10-30 10:35:41Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebSession.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * Unique objet en session qui regroupe les données de session de l'utilisateur
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystWebSession implements Serializable {

    private static final long serialVersionUID = 5982394775074128222L;

    /**
     * Clé utilisée pour stocker l'instance de {@link AgrosystWebSession} dans la map de session HTTP.
     */
    public static final String SESSION_PARAMETER = "agrosystSession";

    protected NavigationContext navigationContext;

    protected String authenticationToken;

    protected UserDto authenticatedUser;

    protected Date lastMessageDate;

    protected List<Message> broadcastMessages =  new ArrayList<Message>();

    /** difined if the messages have already be read */
    protected boolean isFirstTimeMessageRead = false;

    protected Set<AgrosystWebNotification> infoNotifications = Sets.newHashSet();

    protected Set<AgrosystWebNotification> warningNotifications = Sets.newHashSet();

    protected Set<AgrosystWebNotification> errorNotifications = Sets.newHashSet();

    protected List<EdaplosParsingResult> edaplosParsingResults;

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public String getAuthenticationToken() {
        return authenticationToken;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        this.authenticatedUser = null; // AThimel 24/09/13 Force refresh
    }

    public UserDto getAuthenticatedUser() {
        return authenticatedUser;
    }

    public void setAuthenticatedUser(UserDto authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public Set<AgrosystWebNotification> getInfoNotifications() {
        return infoNotifications;
    }

    public void clearInfoNotifications() {
        infoNotifications.clear();
    }

    public void setBroadcastMessages(List<Message> broadcastMessages) {
        this.broadcastMessages = broadcastMessages;
    }

    public List<Message> getBroadcastMessages() {
        return broadcastMessages;
    }

    public boolean isBroadcastMessagesEmpty() {
        return broadcastMessages.isEmpty();
    }

    public void clearBroadcastMessages() {
        this.broadcastMessages.clear();
    }

    public Set<AgrosystWebNotification> getWarningNotifications() {
        return warningNotifications;
    }

    public void clearWarningNotifications(){
        warningNotifications.clear();
    }

    public Set<AgrosystWebNotification> getErrorNotifications() {
        return errorNotifications;
    }

    public void clearErrorNotifications(){
        errorNotifications.clear();
    }

    public Date getLastMessageDate() {
        return lastMessageDate;
    }

    public void setLastMessageDate(Date lastMessageReadDate) {
        this.lastMessageDate = lastMessageReadDate;
    }

    public List<EdaplosParsingResult> getEdaplosParsingResults() {
        return edaplosParsingResults;
    }

    public void setEdaplosParsingResults(List<EdaplosParsingResult> edaplosParsingResults) {
        this.edaplosParsingResults = edaplosParsingResults;
    }

    public void clearEdaplosParsingResult() {
        this.edaplosParsingResults.clear();
    }

    public boolean isFirstTimeMessageRead() {
        return isFirstTimeMessageRead;
    }

    public void setFirstTimeMessageRead(boolean isFirstTimeMessageRead) {
        this.isFirstTimeMessageRead = isFirstTimeMessageRead;
    }
}
