package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersUnactivate.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * Désactivation multiple d'utilisateurs.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UsersUnactivate extends AbstractAdminAction {

    private static final long serialVersionUID = 5338924873719324729L;

    protected transient UserService userService;

    protected Set<String> userIds;

    protected boolean activate;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserIds(Set<String> userIds) {
        this.userIds = userIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/security", "actionName", "users-list"})})
    public String execute() throws Exception {
        checkIsAdmin();
        userService.unactivateUsers(userIds, activate);
        return SUCCESS;
    }

}
