package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadFertiEngraisOrgsJson.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadFertiEngraisOrgsJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadFertiEngraisOrgsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 1L;
    
    protected ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected List<RefFertiEngraisorg> fertiEngraisorgs;

    @Override
    public String execute() {
        fertiEngraisorgs = referentialService.findAllActiveRefFertiorgs();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return fertiEngraisorgs;
    }
}
