package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaReferenceDoseJson.java 5108 2015-10-25 14:22:35Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaReferenceDoseJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.gson.reflect.TypeToken;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.lang.reflect.Type;
import java.util.Set;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class LoadActaReferenceDoseJson extends AbstractJsonAction {

    private static final long serialVersionUID = 888641029321686474L;

    private static final Log log = LogFactory.getLog(LoadActaReferenceDoseJson.class);

    protected transient ReferentialService referentialService;

    protected String phytoProductId;
    protected Set<String> speciesIds;

    protected RefActaDosageSPC dose;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setPhytoProductId(String phytoProductId) {
        this.phytoProductId = phytoProductId;
    }

    @Override
    public String execute() throws Exception {
        dose = referentialService.computeActaReferenceDose(phytoProductId, speciesIds);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return dose;
    }

    public void setSpeciesIds(String json) {
        Type type = new TypeToken<Set<String>>() {}.getType();
        this.speciesIds = getGson().fromJson(json, type);
    }

}
