package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesUnactivate.java 3290 2014-02-18 10:01:34Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Desactivation multiple de decision rules.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4930761732959095035L;

    protected transient ManagementModeService managementModeService;

    protected List<String> decisionRuleIds;

    protected boolean activate;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setDecisionRuleIds(List<String> decisionRuleIds) {
        this.decisionRuleIds = decisionRuleIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "decision-rules-list" }) })
    public String execute() throws Exception {
        managementModeService.unactivateDecisionRules(decisionRuleIds, activate);
        return SUCCESS;
    }
}
