package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: CreateNewRelatedManagementMode.java 3242 2014-02-14 11:32:15Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/CreateNewRelatedManagementMode.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

/**
 * Created by davidcosse on 25/01/14.
 */
public class CreateNewRelatedManagementMode extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2969368449296333610L;

    protected transient ManagementModeService managementModeService;

    protected String growingSystemTopiaId;

    protected ManagementModeCategory category;

    protected String changeReasonFromPlanned;

    protected String mainChangesFromPlanned;

    protected ManagementMode managementMode;

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "management-modes-edit-input", "growingSystemTopiaId", "${growingSystemTopiaId}", "managementModeTopiaId", "${managementMode.topiaId}"})})
    public String execute() throws Exception {
        Preconditions.checkState(category != null);
        Preconditions.checkState(!Strings.isNullOrEmpty(growingSystemTopiaId));

        ManagementModeCategory newManagementModeCategory = category == ManagementModeCategory.PLANNED ? ManagementModeCategory.OBSERVED : ManagementModeCategory.PLANNED;
        managementMode = managementModeService.copyManagementMode(growingSystemTopiaId, newManagementModeCategory, mainChangesFromPlanned, changeReasonFromPlanned);
        notificationSupport.newManagementModeCreated(managementMode);
        return SUCCESS;
    }

    public String getGrowingSystemTopiaId() {
        return growingSystemTopiaId;
    }

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setCategory(ManagementModeCategory category) {
        this.category = category;
    }

    public void setChangeReasonFromPlanned(String changeReasonFromPlanned) {
        this.changeReasonFromPlanned = changeReasonFromPlanned;
    }

    public void setMainChangesFromPlanned(String mainChangesFromPlanned) {
        this.mainChangesFromPlanned = mainChangesFromPlanned;
    }

    public ManagementMode getManagementMode() {
        return managementMode;
    }

    public void setManagementMode(ManagementMode managementMode) {
        this.managementMode = managementMode;
    }


}
