package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansDuplicate.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Duplication unique de dispositif.
 * 
 * @author Eric Chatellier
 */
public class GrowingPlansDuplicate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4930761732959095035L;

    protected transient GrowingPlanService growingPlanService;

    protected String growingPlanIds;

    protected String duplicateDomainId;

    protected boolean duplicateGrowingSystems;

    /** Duplicated growing plan. */
    protected GrowingPlan growingPlan;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanIds(String growingPlanIds) {
        this.growingPlanIds = growingPlanIds;
    }

    public void setDuplicateDomainId(String duplicateDomainId) {
        this.duplicateDomainId = duplicateDomainId;
    }

    public void setDuplicateGrowingSystems(boolean duplicateGrowingSystems) {
        this.duplicateGrowingSystems = duplicateGrowingSystems;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "growing-plans-edit-input", "growingPlanTopiaId", "${growingPlan.topiaId}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "growing-plans-list"})})
    public String execute() throws Exception {
        growingPlan = growingPlanService.duplicateGrowingPlan(growingPlanIds, duplicateDomainId, duplicateGrowingSystems);
        return SUCCESS;
    }
    
    public GrowingPlan getGrowingPlan() {
        return growingPlan;
    }
}
