package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsImportEdaplos.java 4904 2015-04-23 09:24:36Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsImportEdaplos.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import java.util.Map;

/**
 * Import eDaplos xml file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"actionName", "domains-list", "importFileError", "true"})
})
public class DomainsImportEdaplos extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(DomainsImportEdaplos.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected transient EdaplosService edaplosService;

    protected boolean doImport;

    public void setEdaplosService(EdaplosService domainService) {
        this.edaplosService = domainService;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "domains-list"})})
    public String execute() throws Exception {
        if (doImport) {
            try {
                Map<Class, ImportResult> importResults = edaplosService.importEdaplos(session.getEdaplosParsingResults());
                notificationSupport.eDaplosDataImported(importResults);
            } catch (Exception e) {
                log.error(e);
                return ERROR;
            }
        }
        session.clearEdaplosParsingResult();
        return SUCCESS;
    }

    public boolean isDoImport() {
        return doImport;
    }

    public void setDoImport(boolean doImport) {
        this.doImport = doImport;
    }
}
