package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsExport.java 3781 2014-03-17 22:32:09Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Export selected domains into xsl file.
 * 
 * @author Eric Chatellier
 */
public class DomainsExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(DomainsExport.class);

    private static final long serialVersionUID = 2031204987636332755L;
    
    protected List<String> domainIds;

    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    protected transient DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = domainService.exportDomainAsXlsStream(domainIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "domaine-export.xls";
        return filename;
    }
}
