package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Charter.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/Charter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.AgrosystWebAuthenticationFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.struts2.convention.annotation.Action;

/**
 * @author Sylvain Bavencoff : bavencoff@codelutin.com
 */
public class Charter extends AbstractAgrosystAction {
    
    private static final long serialVersionUID = 1L;

    protected transient UserService userService;

    protected boolean accepted;

    protected String next;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    @Action("charter-input")
    public String input() throws Exception {
        return super.input();
    }

    @Override
    public String execute() throws Exception {
        if (accepted) {
            UserDto user = userService.acceptCharter();

            session.setAuthenticatedUser(user);
        }

        if (Strings.isNullOrEmpty(next)
                || next.contains(AgrosystWebAuthenticationFilter.AGROSYST_WEB_LOGIN_ACTION)
                || next.contains(AgrosystWebAuthenticationFilter.AGROSYST_WEB_LOGIN_ACTION_INPUT)) {
            next = servletRequest.getContextPath();
        }
        if (next.contains(";jsessionid=")) {
            next = next.substring(0, next.indexOf(";jsessionid="));
        }
        servletResponse.sendRedirect(next);
        return null;
    }

    public String getNext() {
        return next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }
}
