package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: TrackedEventDto.java 3264 2014-02-17 10:17:26Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/TrackedEventDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.TrackedEventType;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class TrackedEventDto implements Serializable {

    private static final long serialVersionUID = 5831243047660850086L;

    protected Date date;
    protected TrackedEventType type;
    protected UserDto author;
    protected String log;
    protected Set<RoleType> authorRoles;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public TrackedEventType getType() {
        return type;
    }

    public void setType(TrackedEventType type) {
        this.type = type;
    }

    public UserDto getAuthor() {
        return author;
    }

    public void setAuthor(UserDto author) {
        this.author = author;
    }

    public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setAuthorRoles(Set<RoleType> authorRoles) {
        this.authorRoles = authorRoles;
    }

    public Set<RoleType> getAuthorRoles() {
        return authorRoles;
    }
}
