package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractJsonAction.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AbstractJsonAction.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import com.google.common.base.Function;

/**
 * Abstract action used to render custom objects as json string using gson directly in response output stream.
 *
 * @author Eric Chatellier
 * @author Arnaud Thimel : thimel@codelutin.com
 */
@Results({
        @Result(type = "agrosyst-json", name = "success"),
        @Result(type = "agrosyst-json", name = "error")
})
public abstract class AbstractJsonAction extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2293808209162340936L;

    /**
     * Return true for each value. (Used for javascript selection standard).
     */
    public static final Function<String, Boolean> GET_TRUE = new Function<String, Boolean>() {
        @Override
        public Boolean apply(String input) {
            return Boolean.TRUE;
        }
    };

    public static final Function<Object, String> TO_STRING = new Function<Object, String>() {
        @Override
        public String apply(Object input) {
            return String.valueOf(input);
        }
    };

    /**
     * Method to override to get object data to render as json. Method HAS to be public because result support will use
     * this method.
     *
     * @return object to render as json
     */
    public abstract Object getJsonData();

}
