package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebFileUploadInterceptor.java 4027 2014-04-29 08:43:34Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebFileUploadInterceptor.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.FileUploadInterceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ValidationAware;

import fr.inra.agrosyst.web.actions.admin.RunImport;
import fr.inra.agrosyst.web.actions.commons.AttachmentsUploadJson;
import fr.inra.agrosyst.web.actions.domains.DomainsImport;
import fr.inra.agrosyst.web.actions.domains.DomainsImportEdaplos;
import fr.inra.agrosyst.web.actions.effective.EffectiveMeasurementsImport;
import fr.inra.agrosyst.web.actions.growingplans.GrowingPlansImport;
import fr.inra.agrosyst.web.actions.plots.PlotsImport;
import fr.inra.agrosyst.web.actions.security.UsersAndRolesImport;

/**
 * On surcharge {@link org.apache.struts2.interceptor.FileUploadInterceptor} pour aller
 * chercher la taille maximum autorisée et les extensions autorisées dans la configuration.
 *
 * @author kmorin : kmorin@codelutin.com
 * @since 0.8
 */
public class AgrosystWebFileUploadInterceptor extends FileUploadInterceptor {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(AgrosystWebFileUploadInterceptor.class);

    @Override
    protected boolean acceptFile(Object action, File file, String filename, String contentType, String inputName, ValidationAware validation) {

        if (action instanceof AttachmentsUploadJson) {

            Map<String, Object> application = ActionContext.getContext().getApplication();

            AgrosystWebApplicationContext applicationContext =
                    (AgrosystWebApplicationContext) application.get(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);

            AgrosystWebConfig config = applicationContext.getWebConfig();

            setAllowedExtensions(config.getUploadAllowedExtensions());

            setMaximumSize(config.getUploadMaxSize());

            if (log.isDebugEnabled()) {
                log.debug("AttachmentsUpload Upload, allowedTypesSet:" + allowedTypesSet);
            }

        } else if ((action instanceof UsersAndRolesImport || action instanceof RunImport)) {
            setAllowedExtensions("csv");
            if (log.isDebugEnabled()) {
                log.debug("UsersAndRolesImport,RunImport Upload, allowedTypesSet:" + allowedTypesSet);
            }

        } else if(action instanceof DomainsImportEdaplos) {
            setAllowedExtensions("xml");
            if (log.isDebugEnabled()) {
                log.debug("DomainsImportEdaplos Upload, allowedTypesSet:" + allowedTypesSet);
            }
        
        } else if(action instanceof DomainsImport ||
                action instanceof PlotsImport ||
                action instanceof GrowingPlansImport ||
                action instanceof EffectiveMeasurementsImport) {
            setAllowedExtensions("xls");
            if (log.isDebugEnabled()) {
                log.debug("DomainsImport, EffectiveMeasurementsImport Upload, allowedTypesSet:" + allowedTypesSet);
            }

        } else if (log.isDebugEnabled()) {
            log.debug("Other Upload, allowedTypesSet:" + allowedTypesSet);
        }

        boolean result = super.acceptFile(action, file, filename, contentType, inputName, validation);
        return result;

    }

}
