package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsUnactivate.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Desactivation d'une parcelle.
 *
 * @author Eric Chatellier
 */
public class PlotsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -1618279547328450777L;

    protected transient PlotService plotService;

    /** Plot id. */
    protected String plotTopiaId;

    protected boolean activate;

    protected Plot plot;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setPlotTopiaId(String plotTopiaId) {
        this.plotTopiaId = plotTopiaId;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = { "namespace", "/domains", "actionName", "domains-edit-input", "domainTopiaId", "${plot.domain.topiaId}" }) })
    public String execute() throws Exception {
        plot = plotService.unactivatePlot(plotTopiaId, activate);
        notificationSupport.plotUnactivated(plot);
        return SUCCESS;
    }
    
    public Plot getPlot() {
        return plot;
    }
}
