package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsImport.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Import plot XLS file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"namespace", "/domains", "actionName", "domains-edit-input", "domainTopiaId", "${domainTopiaId}", "importFileError", "true"})
})
public class PlotsImport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(PlotsImport.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected String domainTopiaId;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    protected transient PlotService plotService;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }
    
    public String getDomainTopiaId() {
        return domainTopiaId;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"namespace", "/domains", "actionName", "domains-edit-input", "domainTopiaId", "${domainTopiaId}"})})
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            plotService.importPlotsForXlsStream(stream);
            notificationSupport.importSuccess();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import xls file", ex);
            }
            notificationSupport.importError(ex.getMessage());
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }
}
