package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesExport.java 3921 2014-03-31 11:03:47Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.gson.reflect.TypeToken;

/**
 * @author David Cossé
 */
public class ManagementModesExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(ManagementModesExport.class);

    protected List<String> managementModeDtoMap;

    protected transient ManagementModeService service;

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            Type type = new TypeToken<Map<String, ManagementModeDto>>() {}.getType();
            if (managementModeDtoMap != null && !managementModeDtoMap.isEmpty()) {
                for (String map : managementModeDtoMap) {
                    Map<String, ManagementModeDto> managementModeDtos = getGson().fromJson(map, type);
                    if (managementModeDtos != null && !managementModeDtos.isEmpty()) {
                        inputStream = service.exportManagementModesAsXlsStream(managementModeDtos.values());
                    }
                }

            }

        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public void setManagementModeDtoMap(List<String> managementModeDtoMap) {
        this.managementModeDtoMap = managementModeDtoMap;
    }

    public void setService(ManagementModeService service) {
        this.service = service;
    }

    public String getFilename() {
        String filename = "Modes-de-gestions-export.xls";
        return filename;
    }

}
