package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidateGrowingSystems.java 3465 2014-02-25 11:22:17Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/ValidateGrowingSystems.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un SdC.
 *
 * @author Arnaud Thimel (Code Lutin)
 * @since 0.8
 */
public class ValidateGrowingSystems extends AbstractAgrosystAction {

    private static final long serialVersionUID = -6811793980746461606L;

    protected transient GrowingSystemService growingSystemService;

    protected List<String> growingSystemIds;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "growing-systems-list"})})
    public String execute() throws Exception {
        for (String growingSystemId : growingSystemIds) {
            GrowingSystem growingSystem = growingSystemService.validate(growingSystemId);
            notificationSupport.growingSystemValidated(growingSystem);
        }
        return SUCCESS;
    }

}
