package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemEditJson.java 4461 2014-10-23 21:08:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.struts2.convention.annotation.Action;

/**
 * Created by davidcosse on 25/02/14.
 */
public class GrowingSystemEditJson extends AbstractJsonAction {
    
    private static final long serialVersionUID = 1L;
    
    protected GrowingSystemService growingSystemService;

    protected String practicedSystemId;

    protected Object jsonData;

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    @Action("available-growing-system-for-duplication-json")
    public String availableGrowingSystemsForDuplication() {
        NavigationContext navigationContext = getNavigationContext();
        jsonData = growingSystemService.getAvailableGsForDuplication(practicedSystemId, navigationContext);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
