package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansUnactivate.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Desactivation multiple de growingPlans.
 * 
 * @author Eric Chatellier
 */
public class GrowingPlansUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4930761732959095035L;

    protected transient GrowingPlanService growingPlanService;

    protected List<String> growingPlanIds;

    protected boolean activate;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanIds(List<String> growingPlanIds) {
        this.growingPlanIds = growingPlanIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "growing-plans-list" }) })
    public String execute() throws Exception {
        growingPlanService.unactivateGrowingPlans(growingPlanIds, activate);
        return SUCCESS;
    }
}
