package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesActivation.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesActivation.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * Désactivation multiple de domaines.
 * 
 * @author Eric Chatellier
 */
public class GenericEntitiesActivation extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(GenericEntitiesActivation.class);

    private static final long serialVersionUID = -5821886179843474360L;

    protected transient GenericEntityService genericEntityService;

    protected String genericClassName;
    protected List<String> entityIds;
    protected boolean activate;

    public void setGenericEntityService(GenericEntityService genericEntityService) {
        this.genericEntityService = genericEntityService;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}"})})
    public String execute() throws Exception {
        checkIsAdmin();

        try {
            Class<?> klass = Class.forName(genericClassName);
            genericEntityService.unactivateEntities(klass, entityIds, activate);
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occured", e);
            }
        }
        return SUCCESS;
    }

}
