package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsExport.java 3920 2014-03-31 10:15:08Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author David Cossé
 */
public class EffectiveMeasurementsExport extends AbstractAgrosystAction {

    private static final long serialVersionUID = -1612187798771751449L;
    private static final Log log = LogFactory.getLog(EffectiveMeasurementsExport.class);

    protected List<String> selectedEffectiveCropCycleIds;

    protected MeasurementService measurementService;

    public void setSelectedEffectiveCropCycleIds(List<String> selectedEffectiveCropCycleIds) {
        this.selectedEffectiveCropCycleIds = selectedEffectiveCropCycleIds;
    }

    public void setMeasurementService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = measurementService.exportEffectiveMeasurementsAsXlsStream(selectedEffectiveCropCycleIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "Mesures-et-observations-export.xls";
        return filename;
    }
}
