package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsPreImportEdaplos.java 4602 2014-12-05 14:01:31Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsPreImportEdaplos.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

/**
 * Created by davidcosse on 21/10/14.
 */
public class DomainsPreImportEdaplos extends AbstractAgrosystAction{

    private static final Log log = LogFactory.getLog(DomainsImportEdaplos.class);

    private static final long serialVersionUID = 1L;

    protected File file;

    protected transient EdaplosService edaplosService;

    protected List<EdaplosParsingResult> edaplosParsingResults;

    public void setDomainService(EdaplosService edaplosService) {
        this.edaplosService = edaplosService;
    }

    @Override
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            edaplosParsingResults = edaplosService.validEdaplosData(stream);
            session.setEdaplosParsingResults(edaplosParsingResults);

        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import eDaplos file", ex);
            }
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<EdaplosParsingResult> getEdaplosParsingResults() {
        return edaplosParsingResults;
    }
}
